/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.transport.servlet.AbstractCXFServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFServlet
extends AbstractCXFServlet
implements ApplicationListener {
    private GenericApplicationContext childCtx;
    private boolean inRefresh;

    public static Logger getLogger() {
        return LogUtils.getL7dLogger(CXFServlet.class);
    }

    @Override
    public void loadBus(ServletConfig servletConfig) throws ServletException {
        String springCls = "org.springframework.context.ApplicationContext";
        try {
            ClassLoaderUtils.loadClass((String)springCls, ((Object)((Object)this)).getClass());
            this.loadSpringBus(servletConfig);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "FAILED_TO_LOAD_SPRING_BUS", new Object[]{e});
            throw new ServletException("Can't load bus with Spring context class", (Throwable)e);
        }
    }

    private void loadSpringBus(ServletConfig servletConfig) throws ServletException {
        Collection<ApplicationListener> lst;
        ServletContext svCtx = this.getServletContext();
        ApplicationContext ctx = (ApplicationContext)svCtx.getAttribute("interface org.springframework.web.context.WebApplicationContext.ROOT");
        if (ctx == null) {
            Object ctxObject = svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
            if (ctxObject instanceof ApplicationContext) {
                ctx = (ApplicationContext)ctxObject;
            } else if (ctxObject != null) {
                Exception ex = (Exception)ctxObject;
                throw new ServletException((Throwable)ex);
            }
        }
        this.updateContext(servletConfig, ctx);
        if (ctx instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)ctx).addApplicationListener((ApplicationListener)this);
        }
        if (ctx instanceof AbstractApplicationContext && (lst = this.getListeners(ctx)) != null && !lst.contains((Object)this)) {
            lst.add(this);
        }
    }

    private Collection<ApplicationListener> getListeners(ApplicationContext ctx) {
        try {
            Object o = ctx.getClass().getMethod("getApplicationListeners", new Class[0]).invoke((Object)ctx, new Object[0]);
            return CastUtils.cast((Collection)((Collection)o));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContext(ServletConfig servletConfig, ApplicationContext ctx) {
        if (ctx == null) {
            LOG.info("LOAD_BUS_WITHOUT_APPLICATION_CONTEXT");
            this.bus = new SpringBusFactory().createBus();
            ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        } else {
            LOG.info("LOAD_BUS_WITH_APPLICATION_CONTEXT");
            this.inRefresh = true;
            try {
                this.bus = new SpringBusFactory(ctx).createBus();
            }
            finally {
                this.inRefresh = false;
            }
        }
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.replaceDestinationFactory();
        this.controller = this.createServletController(servletConfig);
        this.loadAdditionalConfig(ctx, servletConfig);
    }

    private void loadAdditionalConfig(ApplicationContext ctx, ServletConfig servletConfig) {
        String location = servletConfig.getInitParameter("config-location");
        if (location == null) {
            location = "/WEB-INF/cxf-servlet.xml";
        }
        InputStream is = null;
        try {
            URIResolver resolver;
            is = servletConfig.getServletContext().getResourceAsStream(location);
            if ((is == null || is.available() == -1) && (resolver = new URIResolver(location)).isResolved()) {
                is = resolver.getInputStream();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (is != null) {
            LOG.log(Level.INFO, "BUILD_ENDPOINTS_FROM_CONFIG_LOCATION", new Object[]{location});
            this.childCtx = new GenericApplicationContext(ctx);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.childCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(is, location));
            this.childCtx.refresh();
        }
    }

    @Override
    public void destroy() {
        if (this.childCtx != null) {
            this.childCtx.destroy();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        if (!this.inRefresh && event instanceof ContextRefreshedEvent && this.getServletConfig() != null) {
            try {
                this.inRefresh = true;
                this.updateContext(this.getServletConfig(), ((ContextRefreshedEvent)event).getApplicationContext());
            }
            finally {
                this.inRefresh = false;
            }
        }
    }
}

