/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.transport.jms.JMSOldConfigHolder;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class JMSTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/jms", "http://cxf.apache.org/transports/jms/configuration");
    private static final Set<String> URI_PREFIXES = new HashSet<String>();

    public JMSTransportFactory() {
        super(DEFAULT_NAMESPACES);
    }

    public JMSTransportFactory(Bus b) {
        super(DEFAULT_NAMESPACES, b);
    }

    @Resource(name="cxf")
    public void setBus(Bus bus) {
        super.setBus(bus);
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget());
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        JMSOldConfigHolder old = new JMSOldConfigHolder();
        JMSConfiguration jmsConf = old.createJMSConfigurationFromEndpointInfo(this.bus, endpointInfo, target, true);
        return new JMSConduit(endpointInfo, target, jmsConf, this.bus);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        JMSOldConfigHolder old = new JMSOldConfigHolder();
        JMSConfiguration jmsConf = old.createJMSConfigurationFromEndpointInfo(this.bus, endpointInfo, null, false);
        return new JMSDestination(this.bus, endpointInfo, jmsConf);
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    static {
        URI_PREFIXES.add("jms://");
        URI_PREFIXES.add("jms:");
    }
}

