/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.SequenceMonitor;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.manager.AcksPolicyType;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.PolicyUtils;
import org.apache.cxf.ws.rm.policy.RMAssertion;

public class DestinationSequence
extends AbstractSequence {
    private static final Logger LOG = LogUtils.getL7dLogger(DestinationSequence.class);
    private Destination destination;
    private EndpointReferenceType acksTo;
    private BigInteger lastMessageNumber;
    private SequenceMonitor monitor;
    private boolean acknowledgeOnNextOccasion;
    private List<DeferredAcknowledgment> deferredAcknowledgments;
    private SequenceTermination scheduledTermination;
    private String correlationID;
    private BigInteger inProcessNumber;
    private BigInteger highNumberCompleted = BigInteger.ZERO;
    private List<Continuation> continuations = new LinkedList<Continuation>();

    public DestinationSequence(Identifier i, EndpointReferenceType a, Destination d) {
        this(i, a, null, null);
        this.destination = d;
    }

    public DestinationSequence(Identifier i, EndpointReferenceType a, BigInteger lmn, SequenceAcknowledgement ac) {
        super(i);
        this.acksTo = a;
        this.lastMessageNumber = lmn;
        this.acknowledgement = ac;
        if (null == this.acknowledgement) {
            this.acknowledgement = RMUtils.getWSRMFactory().createSequenceAcknowledgement();
            this.acknowledgement.setIdentifier(this.id);
        }
        this.monitor = new SequenceMonitor();
    }

    public EndpointReferenceType getAcksTo() {
        return this.acksTo;
    }

    public BigInteger getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public SequenceAcknowledgement getAcknowledgment() {
        return this.acknowledgement;
    }

    public String getEndpointIdentifier() {
        return this.destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(Message message) throws SequenceFault {
        BigInteger val;
        BigInteger val2;
        SequenceType st = RMContextUtils.retrieveRMProperties(message, false).getSequence();
        BigInteger messageNumber = st.getMessageNumber();
        LOG.fine("Acknowledging message: " + messageNumber);
        if (null != this.lastMessageNumber && messageNumber.compareTo(this.lastMessageNumber) > 0) {
            throw new SequenceFaultFactory().createLastMessageNumberExceededFault(st.getIdentifier());
        }
        this.monitor.acknowledgeMessage();
        DestinationSequence destinationSequence = this;
        synchronized (destinationSequence) {
            int i;
            boolean done = false;
            for (i = 0; i < this.acknowledgement.getAcknowledgementRange().size(); ++i) {
                SequenceAcknowledgement.AcknowledgementRange r = this.acknowledgement.getAcknowledgementRange().get(i);
                if (r.getLower().compareTo(messageNumber) <= 0 && r.getUpper().compareTo(messageNumber) >= 0) {
                    done = true;
                    break;
                }
                BigInteger diff = r.getLower().subtract(messageNumber);
                if (diff.signum() == 1) {
                    if (!diff.equals(BigInteger.ONE)) break;
                    r.setLower(messageNumber);
                    done = true;
                    break;
                }
                if (!messageNumber.subtract(r.getUpper()).equals(BigInteger.ONE)) continue;
                r.setUpper(messageNumber);
                done = true;
                break;
            }
            if (!done) {
                SequenceAcknowledgement.AcknowledgementRange range = RMUtils.getWSRMFactory().createSequenceAcknowledgementAcknowledgementRange();
                range.setLower(messageNumber);
                range.setUpper(messageNumber);
                this.acknowledgement.getAcknowledgementRange().add(i, range);
            }
            this.mergeRanges();
            this.wakeupAll();
        }
        this.purgeAcknowledged(messageNumber);
        RMAssertion rma = PolicyUtils.getRMAssertion(this.destination.getManager().getRMAssertion(), message);
        long acknowledgementInterval = 0L;
        RMAssertion.AcknowledgementInterval ai = rma.getAcknowledgementInterval();
        if (null != ai && null != (val2 = ai.getMilliseconds())) {
            acknowledgementInterval = val2.longValue();
        }
        this.scheduleAcknowledgement(acknowledgementInterval);
        long inactivityTimeout = 0L;
        RMAssertion.InactivityTimeout iat = rma.getInactivityTimeout();
        if (null != iat && null != (val = iat.getMilliseconds())) {
            inactivityTimeout = val.longValue();
        }
        this.scheduleSequenceTermination(inactivityTimeout);
    }

    void mergeRanges() {
        List<SequenceAcknowledgement.AcknowledgementRange> ranges = this.acknowledgement.getAcknowledgementRange();
        for (int i = ranges.size() - 1; i > 0; --i) {
            SequenceAcknowledgement.AcknowledgementRange current = ranges.get(i);
            SequenceAcknowledgement.AcknowledgementRange previous = ranges.get(i - 1);
            if (!current.getLower().subtract(previous.getUpper()).equals(BigInteger.ONE)) continue;
            previous.setUpper(current.getUpper());
            ranges.remove(i);
        }
    }

    void setDestination(Destination d) {
        this.destination = d;
    }

    Destination getDestination() {
        return this.destination;
    }

    SequenceMonitor getMonitor() {
        return this.monitor;
    }

    void setLastMessageNumber(BigInteger lmn) {
        this.lastMessageNumber = lmn;
    }

    boolean canPiggybackAckOnPartialResponse() {
        return this.getAcksTo().getAddress().getValue().equals(RMConstants.getAnonymousAddress());
    }

    boolean applyDeliveryAssurance(BigInteger mn, Message message) throws RMException {
        Continuation cont = this.getContinuation(message);
        DeliveryAssuranceType da = this.destination.getManager().getDeliveryAssurance();
        if (cont != null && da.isSetInOrder() && !cont.isNew()) {
            return this.waitInQueue(mn, !da.isSetAtLeastOnce() && !da.isSetExactlyOnce(), message, cont);
        }
        if ((da.isSetExactlyOnce() || da.isSetAtMostOnce()) && this.isAcknowledged(mn)) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("MESSAGE_ALREADY_DELIVERED_EXC", LOG, new Object[]{mn, this.getIdentifier().getValue()});
            LOG.log(Level.INFO, msg.toString());
            throw new RMException(msg);
        }
        if (da.isSetInOrder()) {
            return this.waitInQueue(mn, !da.isSetAtLeastOnce() && !da.isSetExactlyOnce(), message, cont);
        }
        return true;
    }

    private Continuation getContinuation(Message message) {
        if (message == null) {
            return null;
        }
        return (Continuation)message.get(Continuation.class);
    }

    synchronized boolean waitInQueue(BigInteger mn, boolean canSkip, Message message, Continuation continuation) {
        while (true) {
            ContinuationProvider p;
            BigInteger compare;
            BigInteger diff;
            if (this.inProcessNumber == null && (BigInteger.ONE.equals(diff = mn.subtract(this.highNumberCompleted)) || canSkip && diff.signum() > 0)) {
                this.inProcessNumber = mn;
                return true;
            }
            BigInteger bigInteger = compare = this.inProcessNumber == null ? this.highNumberCompleted : this.inProcessNumber;
            if (compare.compareTo(mn) >= 0) {
                return false;
            }
            if (continuation == null && (p = (ContinuationProvider)message.get(ContinuationProvider.class)) != null) {
                boolean isOneWay = message.getExchange().isOneWay();
                message.getExchange().setOneWay(false);
                continuation = p.getContinuation();
                message.getExchange().setOneWay(isOneWay);
                message.put(Continuation.class, (Object)continuation);
            }
            if (continuation != null) {
                continuation.setObject((Object)message);
                if (continuation.suspend(-1L)) {
                    this.continuations.add(continuation);
                    throw new SuspendedInvocationException();
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
            }
        }
    }

    synchronized void wakeupAll() {
        while (!this.continuations.isEmpty()) {
            Continuation c = this.continuations.remove(0);
            c.resume();
        }
        this.notifyAll();
    }

    synchronized void processingComplete(BigInteger mn) {
        this.inProcessNumber = null;
        this.highNumberCompleted = mn;
        this.wakeupAll();
    }

    void purgeAcknowledged(BigInteger messageNr) {
        RMStore store = this.destination.getManager().getStore();
        if (null == store) {
            return;
        }
        ArrayList<BigInteger> messageNrs = new ArrayList<BigInteger>();
        messageNrs.add(messageNr);
        store.removeMessages(this.getIdentifier(), messageNrs, false);
    }

    void acknowledgmentSent() {
        this.acknowledgeOnNextOccasion = false;
    }

    public boolean sendAcknowledgement() {
        return this.acknowledgeOnNextOccasion;
    }

    void setCorrelationID(String cid) {
        this.correlationID = cid;
    }

    String getCorrelationID() {
        return this.correlationID;
    }

    void scheduleAcknowledgement(long acknowledgementInterval) {
        AcksPolicyType ap = this.destination.getManager().getDestinationPolicy().getAcksPolicy();
        if (acknowledgementInterval > 0L && this.getMonitor().getMPM() >= ap.getIntraMessageThreshold()) {
            LOG.fine("Schedule deferred acknowledgment");
            this.scheduleDeferredAcknowledgement(acknowledgementInterval);
        } else {
            LOG.fine("Schedule immediate acknowledgment");
            this.scheduleImmediateAcknowledgement();
            this.destination.getManager().getTimer().schedule((TimerTask)new ImmediateFallbackAcknowledgment(), ap.getImmediaAcksTimeout().longValue());
        }
    }

    void scheduleImmediateAcknowledgement() {
        this.acknowledgeOnNextOccasion = true;
    }

    synchronized void scheduleSequenceTermination(long inactivityTimeout) {
        boolean scheduled;
        if (inactivityTimeout <= 0L) {
            return;
        }
        boolean bl = scheduled = null != this.scheduledTermination;
        if (null == this.scheduledTermination) {
            this.scheduledTermination = new SequenceTermination();
        }
        this.scheduledTermination.updateInactivityTimeout(inactivityTimeout);
        if (!scheduled) {
            this.destination.getManager().getTimer().schedule((TimerTask)this.scheduledTermination, inactivityTimeout);
        }
    }

    synchronized void scheduleDeferredAcknowledgement(long delay) {
        if (null == this.deferredAcknowledgments) {
            this.deferredAcknowledgments = new ArrayList<DeferredAcknowledgment>();
        }
        long now = System.currentTimeMillis();
        long expectedExecutionTime = now + delay;
        for (DeferredAcknowledgment da : this.deferredAcknowledgments) {
            if (da.scheduledExecutionTime() > expectedExecutionTime) continue;
            return;
        }
        DeferredAcknowledgment da = new DeferredAcknowledgment();
        this.deferredAcknowledgments.add(da);
        this.destination.getManager().getTimer().schedule((TimerTask)da, delay);
        LOG.fine("Scheduled acknowledgment to be sent in " + delay + " ms");
    }

    synchronized void cancelDeferredAcknowledgments() {
        if (null == this.deferredAcknowledgments) {
            return;
        }
        for (int i = this.deferredAcknowledgments.size() - 1; i >= 0; --i) {
            DeferredAcknowledgment da = this.deferredAcknowledgments.get(i);
            da.cancel();
        }
    }

    synchronized void cancelTermination() {
        if (null != this.scheduledTermination) {
            this.scheduledTermination.cancel();
        }
    }

    final class SequenceTermination
    extends TimerTask {
        private long maxInactivityTimeout;

        SequenceTermination() {
        }

        void updateInactivityTimeout(long timeout) {
            this.maxInactivityTimeout = Math.max(this.maxInactivityTimeout, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DestinationSequence destinationSequence = DestinationSequence.this;
            synchronized (destinationSequence) {
                DestinationSequence.this.scheduledTermination = null;
                RMEndpoint rme = DestinationSequence.this.destination.getReliableEndpoint();
                long lat = Math.max(rme.getLastControlMessage(), rme.getLastApplicationMessage());
                if (0L == lat) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - lat >= this.maxInactivityTimeout) {
                    LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"TERMINATING_INACTIVE_SEQ_MSG", (Object)DestinationSequence.this.getIdentifier().getValue());
                    DestinationSequence.this.destination.removeSequence(DestinationSequence.this);
                } else {
                    SequenceTermination st = new SequenceTermination();
                    st.updateInactivityTimeout(this.maxInactivityTimeout);
                    DestinationSequence.this.destination.getManager().getTimer().schedule((TimerTask)st, this.maxInactivityTimeout);
                }
            }
        }
    }

    final class ImmediateFallbackAcknowledgment
    extends TimerTask {
        ImmediateFallbackAcknowledgment() {
        }

        public void run() {
            LOG.fine("timer task: send acknowledgment.");
            if (!DestinationSequence.this.sendAcknowledgement()) {
                return;
            }
            try {
                RMEndpoint rme = DestinationSequence.this.destination.getReliableEndpoint();
                Proxy proxy = rme.getProxy();
                proxy.acknowledge(DestinationSequence.this);
            }
            catch (RMException rMException) {
                // empty catch block
            }
        }
    }

    final class DeferredAcknowledgment
    extends TimerTask {
        DeferredAcknowledgment() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object rme;
            LOG.fine("timer task: send acknowledgment.");
            DestinationSequence.this.scheduleImmediateAcknowledgement();
            try {
                rme = DestinationSequence.this.destination.getReliableEndpoint();
                Proxy proxy = ((RMEndpoint)rme).getProxy();
                proxy.acknowledge(DestinationSequence.this);
            }
            catch (RMException rMException) {
                DestinationSequence destinationSequence = DestinationSequence.this;
                synchronized (destinationSequence) {
                    DestinationSequence.this.deferredAcknowledgments.remove(this);
                }
            }
            finally {
                rme = DestinationSequence.this;
                synchronized (rme) {
                    DestinationSequence.this.deferredAcknowledgments.remove(this);
                }
            }
        }
    }
}

