/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.OperationProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.InterfaceMapper;
import org.w3c.dom.Element;

public class PortTypeProcessor
extends AbstractProcessor {
    private List<QName> operationMap = new ArrayList<QName>();

    public PortTypeProcessor(ToolContext c) {
        super(c);
    }

    public static JavaInterface getInterface(ToolContext context, ServiceInfo serviceInfo, InterfaceInfo interfaceInfo) throws ToolException {
        JavaInterface intf = (JavaInterface)interfaceInfo.getProperty("JavaInterface", JavaInterface.class);
        if (intf == null) {
            JAXWSBinding infBinding;
            intf = new InterfaceMapper(context).map(interfaceInfo);
            JAXWSBinding jaxwsBinding = null;
            if (serviceInfo.getDescription() != null) {
                jaxwsBinding = (JAXWSBinding)serviceInfo.getDescription().getExtensor(JAXWSBinding.class);
            }
            if ((infBinding = (JAXWSBinding)interfaceInfo.getExtensor(JAXWSBinding.class)) != null && infBinding.getPackage() != null) {
                intf.setPackageName(infBinding.getPackage());
            } else if (jaxwsBinding != null && jaxwsBinding.getPackage() != null) {
                intf.setPackageName(jaxwsBinding.getPackage());
            }
            if (infBinding != null && !infBinding.getPackageJavaDoc().equals("")) {
                intf.setPackageJavaDoc(infBinding.getPackageJavaDoc());
            } else if (jaxwsBinding != null && !jaxwsBinding.getPackageJavaDoc().equals("")) {
                intf.setPackageJavaDoc(jaxwsBinding.getPackageJavaDoc());
            }
            String name = intf.getName();
            if (infBinding != null && infBinding.getJaxwsClass() != null && infBinding.getJaxwsClass().getClassName() != null) {
                name = infBinding.getJaxwsClass().getClassName();
                if (name.contains(".")) {
                    intf.setPackageName(name.substring(0, name.lastIndexOf(46)));
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                intf.setClassJavaDoc(infBinding.getJaxwsClass().getComments());
            }
            ClassCollector collector = (ClassCollector)context.get(ClassCollector.class);
            if (context.optionSet("autoNameResolution")) {
                int count = 0;
                String checkName = name;
                while (collector.isReserved(intf.getPackageName(), checkName)) {
                    checkName = name + "_" + ++count;
                }
                name = checkName;
            } else if (collector.isReserved(intf.getPackageName(), name)) {
                throw new ToolException("RESERVED_SEI_NAME", LOG, new Object[]{name});
            }
            interfaceInfo.setProperty("InterfaceName", (Object)name);
            intf.setName(name);
            collector.addSeiClassName(intf.getPackageName(), intf.getName(), intf.getPackageName() + "." + intf.getName());
            interfaceInfo.setProperty("JavaInterface", (Object)intf);
        }
        return intf;
    }

    public void processClassNames(ServiceInfo serviceInfo) throws ToolException {
        InterfaceInfo interfaceInfo = serviceInfo.getInterface();
        if (interfaceInfo == null) {
            return;
        }
        PortTypeProcessor.getInterface(this.context, serviceInfo, interfaceInfo);
    }

    public void process(ServiceInfo serviceInfo) throws ToolException {
        this.operationMap.clear();
        JavaModel jmodel = (JavaModel)this.context.get(JavaModel.class);
        InterfaceInfo interfaceInfo = serviceInfo.getInterface();
        if (interfaceInfo == null) {
            return;
        }
        JavaInterface intf = PortTypeProcessor.getInterface(this.context, serviceInfo, interfaceInfo);
        intf.setJavaModel(jmodel);
        Element handler = (Element)this.context.get("handler-chain");
        intf.setHandlerChains(handler);
        Collection operations = interfaceInfo.getOperations();
        for (OperationInfo operation : operations) {
            if (this.isOverloading(operation.getName())) {
                LOG.log(Level.WARNING, "SKIP_OVERLOADED_OPERATION", operation.getName());
                continue;
            }
            OperationProcessor operationProcessor = new OperationProcessor(this.context);
            operationProcessor.process(intf, operation);
        }
        jmodel.setLocation(intf.getLocation());
        jmodel.addInterface(intf.getName(), intf);
    }

    private boolean isOverloading(QName operationName) {
        if (this.operationMap.contains(operationName)) {
            return true;
        }
        this.operationMap.add(operationName);
        return false;
    }
}

