/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownStatesEnum;
import org.apache.directory.api.ldap.extras.extended.gracefulShutdown.GracefulShutdownRequest;
import org.apache.directory.api.ldap.extras.extended.gracefulShutdown.GracefulShutdownRequestImpl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulShutdownGrammar
extends AbstractGrammar<GracefulShutdownContainer> {
    static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static GracefulShutdownGrammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.setName(GracefulShutdownGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE.ordinal()][256];
        this.transitions[GracefulShutdownStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.START_STATE, (Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<GracefulShutdownContainer>("Init GracefulShutdown"){

            public void action(GracefulShutdownContainer container) {
                GracefulShutdownRequestDecorator gracefulShutdownRequest = new GracefulShutdownRequestDecorator(LdapApiServiceFactory.getSingleton(), (GracefulShutdownRequest)new GracefulShutdownRequestImpl());
                container.setGracefulShutdownRequest(gracefulShutdownRequest);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (Enum)GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown time offline"){

            public void action(GracefulShutdownContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse((BerValue)value, (int)0, (int)720);
                    if (IS_DEBUG) {
                        LOG.debug("Time Offline = " + timeOffline);
                    }
                    container.getGracefulShutdownRequest().setTimeOffline(timeOffline);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04037, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, (Enum)GracefulShutdownStatesEnum.DELAY_STATE, 128, (Action)new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            public void action(GracefulShutdownContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((BerValue)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    container.getGracefulShutdownRequest().setDelay(delay);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04036, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (Enum)GracefulShutdownStatesEnum.DELAY_STATE, 128, (Action)new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            public void action(GracefulShutdownContainer container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = container;
                BerValue value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((BerValue)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdownRequest().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04036, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static GracefulShutdownGrammar getInstance() {
        return instance;
    }
}

