/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.cursor;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();

    public EmptyCursor() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EmptyCursor : {}", (Object)this);
        }
    }

    @Override
    public boolean available() {
        return false;
    }

    @Override
    public void before(E element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
    }

    @Override
    public void after(E element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        return false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        return false;
    }

    @Override
    public E get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_02004_EMPTY_CURSOR, (Object[])new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

