/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchNode
extends AbstractExprNode {
    protected List<ExprNode> children = null;

    protected BranchNode(AssertionType assertionType, List<ExprNode> childList) {
        super(assertionType);
        this.children = null == childList ? new ArrayList<ExprNode>(2) : childList;
        this.isSchemaAware = true;
    }

    protected BranchNode(AssertionType assertionType, ExprNode ... childList) {
        super(assertionType);
        if (null == this.children) {
            this.children = new ArrayList<ExprNode>(childList.length);
        }
        CollectionUtils.addAll(this.children, (Object[])childList);
    }

    protected BranchNode(AssertionType assertionType) {
        super(assertionType);
        this.children = new ArrayList<ExprNode>(2);
        this.isSchemaAware = true;
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    @Override
    public ExprNode clone() {
        ExprNode clone = super.clone();
        if (this.children != null) {
            ((BranchNode)clone).children = new ArrayList<ExprNode>();
            for (ExprNode child : this.children) {
                ((BranchNode)clone).children.add(child.clone());
            }
        }
        return clone;
    }

    public void addNode(ExprNode node) {
        this.children.add(node);
    }

    public void addNodeToHead(ExprNode node) {
        this.children.add(0, node);
    }

    public List<ExprNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExprNode> list) {
        this.children = list;
    }

    public ExprNode getFirstChild() {
        if (this.children.size() > 0) {
            return this.children.get(0);
        }
        return null;
    }

    @Override
    public final Object accept(FilterVisitor visitor) {
        if (visitor.isPrefix()) {
            List<ExprNode> childrenList = visitor.getOrder(this, this.children);
            ExprNode result = null;
            if (visitor.canVisit(this)) {
                result = (ExprNode)visitor.visit(this);
            }
            for (ExprNode node : childrenList) {
                node.accept(visitor);
            }
            return result;
        }
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        if (this.children != null) {
            for (ExprNode child : this.children) {
                h = h * 17 + child.hashCode();
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BranchNode)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        BranchNode otherExprNode = (BranchNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherChildren == this.children) {
            return true;
        }
        if (this.children.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ExprNode otherChild;
            ExprNode child = this.children.get(i);
            if (child.equals(otherChild = this.children.get(i))) continue;
            return false;
        }
        return true;
    }
}

