/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;

public class ScopeNode
extends AbstractExprNode {
    private final SearchScope scope;
    private final Dn baseDn;
    private final String baseId;
    private final AliasDerefMode aliasDerefAliases;

    public ScopeNode(AliasDerefMode aliasDerefAliases, Dn baseDn, String baseId, SearchScope scope) {
        super(AssertionType.SCOPE);
        this.scope = scope;
        this.baseDn = baseDn;
        this.aliasDerefAliases = aliasDerefAliases;
        this.baseId = baseId;
        this.isSchemaAware = true;
    }

    public boolean isLeaf() {
        return true;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public Dn getBaseDn() {
        return this.baseDn;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public AliasDerefMode getDerefAliases() {
        return this.aliasDerefAliases;
    }

    public Object accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ScopeNode)) {
            return false;
        }
        ScopeNode that = (ScopeNode)obj;
        if (this.aliasDerefAliases == null ? that.aliasDerefAliases != null : !this.aliasDerefAliases.equals((Object)that.aliasDerefAliases)) {
            return false;
        }
        if (this.baseDn == null ? that.baseDn != null : !this.baseDn.equals(that.baseDn)) {
            return false;
        }
        if (this.scope.getScope() != that.scope.getScope()) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.aliasDerefAliases != null ? this.aliasDerefAliases.hashCode() : 0);
        h = h * 17 + (this.baseDn != null ? this.baseDn.hashCode() : 0);
        h = h * 17 + this.scope.getScope();
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(#{");
        switch (this.scope) {
            case OBJECT: {
                buf.append("OBJECT_SCOPE");
                break;
            }
            case ONELEVEL: {
                buf.append("ONE_LEVEL_SCOPE");
                break;
            }
            case SUBTREE: {
                buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(", '");
        buf.append(this.baseDn);
        buf.append("', ");
        buf.append((Object)this.aliasDerefAliases);
        buf.append("}");
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

