/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryMethodSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DeliveryMethodSyntaxChecker.class);
    private static final String[] PDMS = new String[]{"any", "mhs", "physical", "telex", "teletex", "g3fax", "g4fax", "ia5", "videotex", "telephone"};
    private static final Set<String> DELIVERY_METHODS = new HashSet<String>();

    public DeliveryMethodSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.14");
    }

    private int isPdm(String strValue, int start, Set<String> pdms) {
        int pos = start;
        while (Chars.isAlphaDigit((String)strValue, (int)pos)) {
            ++pos;
        }
        if (pos == start) {
            return -1;
        }
        String pdm = strValue.substring(start, pos);
        if (!DELIVERY_METHODS.contains(pdm)) {
            return -1;
        }
        if (pdms.contains(pdm)) {
            return -1;
        }
        pdms.add(pdm);
        return pos;
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int length = strValue.length();
        int pos = 0;
        HashSet<String> pmds = new HashSet<String>();
        if ((pos = this.isPdm(strValue, pos, pmds)) == -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        while (pos < length) {
            while (Strings.isCharASCII((String)strValue, (int)pos, (char)' ')) {
                ++pos;
            }
            if (!Strings.isCharASCII((String)strValue, (int)pos, (char)'$')) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            ++pos;
            while (Strings.isCharASCII((String)strValue, (int)pos, (char)' ')) {
                ++pos;
            }
            if ((pos = this.isPdm(strValue, pos, pmds)) != -1) continue;
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }

    static {
        for (String country : PDMS) {
            DELIVERY_METHODS.add(country);
        }
    }
}

