/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPreferenceSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MailPreferenceSyntaxChecker.class);

    public MailPreferenceSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.32");
    }

    protected MailPreferenceSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        boolean result;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() < 8 || strValue.length() > 18) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean bl = result = "NO-LISTS".equals(strValue) || "ANY-LIST".equals(strValue) || "PROFESSIONAL-LISTS".equals(strValue);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

