/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelephoneNumberSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(TelephoneNumberSyntaxChecker.class);
    private List<String> regexps;
    private List<Pattern> compiledREs;
    private static final String DEFAULT_REGEXP = "^ *[+]? *((\\([0-9- ]+\\))|[0-9- ]+)+$";
    private Pattern defaultPattern = Pattern.compile("^ *[+]? *((\\([0-9- ]+\\))|[0-9- ]+)+$");
    protected boolean defaultMandatory = false;

    public TelephoneNumberSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.50");
    }

    public void addRegexp(String regexp) {
        if (this.defaultMandatory) {
            return;
        }
        try {
            Pattern compiledRE = Pattern.compile(regexp);
            if (this.regexps == null) {
                this.regexps = new ArrayList<String>();
                this.compiledREs = new ArrayList<Pattern>();
            }
            this.regexps.add(regexp);
            this.compiledREs.add(compiledRE);
        }
        catch (PatternSyntaxException pse) {
            return;
        }
    }

    public void setDefaultRegexp(String regexp) {
        try {
            this.defaultPattern = Pattern.compile(regexp);
            this.defaultMandatory = true;
            this.regexps = null;
            this.compiledREs = null;
        }
        catch (PatternSyntaxException pse) {
            return;
        }
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (this.defaultMandatory) {
            boolean result = this.defaultPattern.matcher(strValue).matches();
            if (result) {
                LOG.debug("Syntax valid for '{}'", value);
            } else {
                LOG.debug("Syntax invalid for '{}'", value);
            }
            return result;
        }
        if (this.defaultPattern.matcher(strValue).matches()) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        if (this.compiledREs == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        for (Pattern pattern : this.compiledREs) {
            if (!pattern.matcher(strValue).matches()) continue;
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

