/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttributeTypeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTypeHelper.class);

    private AttributeTypeHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                attributeType.unlock();
                AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
                if (!AttributeTypeHelper.buildSuperior(attributeType, errors, registries)) {
                    return;
                }
                AttributeTypeHelper.buildSyntax(attributeType, errors, registries);
                AttributeTypeHelper.buildEquality(attributeType, errors, registries);
                AttributeTypeHelper.buildOrdering(attributeType, errors, registries);
                AttributeTypeHelper.buildSubstring(attributeType, errors, registries);
                AttributeTypeHelper.checkUsage(attributeType, errors);
                AttributeTypeHelper.checkCollective(attributeType, errors);
                attributeTypeRegistry.addMappingFor(attributeType);
                attributeTypeRegistry.registerDescendants(attributeType, attributeType.getSuperior());
                if (attributeType.getEquality() != null) {
                    registries.addReference(attributeType, attributeType.getEquality());
                }
                if (attributeType.getOrdering() != null) {
                    registries.addReference(attributeType, attributeType.getOrdering());
                }
                if (attributeType.getSubstring() != null) {
                    registries.addReference(attributeType, attributeType.getSubstring());
                }
                if (attributeType.getSyntax() != null) {
                    registries.addReference(attributeType, attributeType.getSyntax());
                }
                if (attributeType.getSuperior() != null) {
                    registries.addReference(attributeType, attributeType.getSuperior());
                }
            }
            finally {
                attributeType.lock();
            }
        }
    }

    private static boolean buildSuperior(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) {
        MutableAttributeType currentSuperior = null;
        AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
        String superiorOid = attributeType.getSuperiorOid();
        if (superiorOid != null) {
            try {
                currentSuperior = (MutableAttributeType)attributeTypeRegistry.lookup(superiorOid);
            }
            catch (Exception e) {
                String msg = I18n.err((I18n)I18n.ERR_04303, (Object[])new Object[]{superiorOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUPERIOR, msg, e);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(superiorOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
                return false;
            }
            if (currentSuperior != null) {
                if (currentSuperior.isCollective()) {
                    String msg = I18n.err((I18n)I18n.ERR_04482_CANNOT_SUBTYPE_COLLECTIVE, (Object[])new Object[]{currentSuperior, attributeType.getName()});
                    LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_CANNOT_SUBTYPE_COLLECTIVE_AT, msg);
                    ldapSchemaException.setSourceObject(attributeType);
                    errors.add(ldapSchemaException);
                    LOG.info(msg);
                    return false;
                }
                attributeType.setSuperior(currentSuperior);
                if (currentSuperior.getSuperior() == null) {
                    registries.buildReference(errors, currentSuperior);
                }
                try {
                    attributeTypeRegistry.registerDescendants(attributeType, currentSuperior);
                }
                catch (LdapException ne) {
                    errors.add(ne);
                    LOG.info(ne.getMessage());
                    return false;
                }
                HashSet<String> superiors = new HashSet<String>();
                superiors.add(attributeType.getOid());
                boolean isOk = true;
                for (AttributeType tmp = currentSuperior; tmp != null; tmp = tmp.getSuperior()) {
                    if (superiors.contains(tmp.getOid())) {
                        String msg = I18n.err((I18n)I18n.ERR_04304, (Object[])new Object[]{attributeType.getName()});
                        LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_CYCLE_TYPE_HIERARCHY, msg);
                        ldapSchemaException.setSourceObject(attributeType);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        isOk = false;
                        break;
                    }
                    superiors.add(tmp.getOid());
                }
                superiors.clear();
                return isOk;
            }
            String msg = I18n.err((I18n)I18n.ERR_04305, (Object[])new Object[]{superiorOid, attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUPERIOR, msg);
            ldapSchemaException.setSourceObject(attributeType);
            ldapSchemaException.setRelatedId(superiorOid);
            errors.add(ldapSchemaException);
            LOG.info(msg);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildSyntax(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) {
        String syntaxOid = attributeType.getSyntaxOid();
        if (syntaxOid != null) {
            LdapSyntax currentSyntax = null;
            try {
                currentSyntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(syntaxOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_04306, (Object[])new Object[]{syntaxOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SYNTAX, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(syntaxOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
                return;
            }
            if (currentSyntax != null) {
                attributeType.setSyntax(currentSyntax);
                return;
            }
            String msg = I18n.err((I18n)I18n.ERR_04306, (Object[])new Object[]{syntaxOid, attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SYNTAX, msg);
            ldapSchemaException.setSourceObject(attributeType);
            ldapSchemaException.setRelatedId(syntaxOid);
            errors.add(ldapSchemaException);
            LOG.info(msg);
            return;
        }
        if (attributeType.getSuperior() != null) {
            attributeType.setSyntax(attributeType.getSuperior().getSyntax());
            return;
        }
        String msg = I18n.err((I18n)I18n.ERR_04307, (Object[])new Object[]{attributeType.getName()});
        LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_SYNTAX_OR_SUPERIOR_REQUIRED, msg);
        ldapSchemaException.setSourceObject(attributeType);
        errors.add(ldapSchemaException);
        LOG.info(msg);
    }

    private static void buildEquality(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) {
        String equalityOid = attributeType.getEqualityOid();
        if (equalityOid != null) {
            MatchingRule currentEquality = null;
            try {
                currentEquality = (MatchingRule)registries.getMatchingRuleRegistry().lookup(equalityOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_04308, (Object[])new Object[]{equalityOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_EQUALITY_MATCHING_RULE, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(equalityOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
                return;
            }
            if (currentEquality != null) {
                attributeType.setEquality(currentEquality);
                attributeType.setEqualityOid(equalityOid);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_04309, (Object[])new Object[]{equalityOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_EQUALITY_MATCHING_RULE, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(equalityOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
            }
        } else {
            AttributeType superior = attributeType.getSuperior();
            if (superior != null && superior.getEquality() != null) {
                attributeType.setEquality(superior.getEquality());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildSubstring(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) {
        String substringOid = attributeType.getSubstringOid();
        if (substringOid == null) {
            AttributeType superior = attributeType.getSuperior();
            if (superior == null) return;
            if (superior.getSubstring() == null) return;
            attributeType.setSubstring(superior.getSubstring());
            return;
        }
        MatchingRule currentSubstring = null;
        try {
            currentSubstring = (MatchingRule)registries.getMatchingRuleRegistry().lookup(substringOid);
        }
        catch (LdapException ne) {
            String msg = I18n.err((I18n)I18n.ERR_04312, (Object[])new Object[]{substringOid, attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUBSTRING_MATCHING_RULE, msg, ne);
            ldapSchemaException.setSourceObject(attributeType);
            ldapSchemaException.setRelatedId(substringOid);
            errors.add(ldapSchemaException);
            LOG.info(msg);
            return;
        }
        if (currentSubstring != null) {
            attributeType.setSubstring(currentSubstring);
            return;
        }
        String msg = I18n.err((I18n)I18n.ERR_04313, (Object[])new Object[]{substringOid, attributeType.getName()});
        LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUBSTRING_MATCHING_RULE, msg);
        ldapSchemaException.setSourceObject(attributeType);
        ldapSchemaException.setRelatedId(substringOid);
        errors.add(ldapSchemaException);
        LOG.info(msg);
    }

    private static void buildOrdering(MutableAttributeType attributeType, List<Throwable> errors, Registries registries) {
        String orderingOid = attributeType.getOrderingOid();
        if (orderingOid != null) {
            MatchingRule currentOrdering = null;
            try {
                currentOrdering = (MatchingRule)registries.getMatchingRuleRegistry().lookup(orderingOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_04310, (Object[])new Object[]{orderingOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_ORDERING_MATCHING_RULE, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(orderingOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
                return;
            }
            if (currentOrdering != null) {
                attributeType.setOrdering(currentOrdering);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_04311, (Object[])new Object[]{orderingOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_ORDERING_MATCHING_RULE, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(orderingOid);
                errors.add(ldapSchemaException);
                LOG.info(msg);
            }
        } else {
            AttributeType superior = attributeType.getSuperior();
            if (superior != null && superior.getOrdering() != null) {
                attributeType.setOrdering(superior.getOrdering());
            }
        }
    }

    private static void checkUsage(AttributeType attributeType, List<Throwable> errors) {
        AttributeType superior = attributeType.getSuperior();
        if (superior != null && attributeType.getUsage() != superior.getUsage()) {
            String msg = I18n.err((I18n)I18n.ERR_04314, (Object[])new Object[]{attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_MUST_HAVE_SAME_USAGE_THAN_SUPERIOR, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errors.add(ldapSchemaException);
            LOG.info(msg);
            return;
        }
        if (!attributeType.isUserModifiable() && attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) {
            String msg = I18n.err((I18n)I18n.ERR_04315, (Object[])new Object[]{attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_USER_APPLICATIONS_USAGE_MUST_BE_USER_MODIFIABLE, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errors.add(ldapSchemaException);
            LOG.info(msg);
        }
    }

    private static void checkCollective(MutableAttributeType attributeType, List<Throwable> errors) {
        LdapSchemaException ldapSchemaException;
        String msg;
        AttributeType superior = attributeType.getSuperior();
        if (superior != null && superior.isCollective()) {
            attributeType.setCollective(true);
        }
        if (attributeType.isCollective() && attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) {
            msg = I18n.err((I18n)I18n.ERR_04316, (Object[])new Object[]{attributeType.getName()});
            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_COLLECTIVE_MUST_HAVE_USER_APPLICATIONS_USAGE, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errors.add(ldapSchemaException);
            LOG.info(msg);
        }
        if (attributeType.isCollective() && attributeType.isSingleValued()) {
            msg = I18n.err((I18n)I18n.ERR_04483_COLLECTIVE_NOT_MULTI_VALUED, (Object[])new Object[]{attributeType.getName()});
            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_COLLECTIVE_CANNOT_BE_SINGLE_VALUED, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errors.add(ldapSchemaException);
            LOG.info(msg);
        }
    }

    public static void removeFromRegistries(AttributeType attributeType, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
            attributeTypeRegistry.removeMappingFor(attributeType);
            attributeTypeRegistry.unregisterDescendants(attributeType, attributeType.getSuperior());
            if (attributeType.getEquality() != null) {
                registries.delReference(attributeType, attributeType.getEquality());
            }
            if (attributeType.getOrdering() != null) {
                registries.delReference(attributeType, attributeType.getOrdering());
            }
            if (attributeType.getSubstring() != null) {
                registries.delReference(attributeType, attributeType.getSubstring());
            }
            if (attributeType.getSyntax() != null) {
                registries.delReference(attributeType, attributeType.getSyntax());
            }
            if (attributeType.getSuperior() != null) {
                registries.delReference(attributeType, attributeType.getSuperior());
            }
        }
    }
}

