/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.server.changepw.value.ChangePasswordData;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ChangePasswordDataEncoder {
    public byte[] encode(ChangePasswordData data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence dataSequence = this.encodeDataSequence(data);
        aos.writeObject(dataSequence);
        aos.close();
        return baos.toByteArray();
    }

    public void encode(ChangePasswordData data, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence sequence = this.encodeDataSequence(data);
        aos.writeObject(sequence);
        aos.close();
    }

    private DERSequence encodeDataSequence(ChangePasswordData data) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, new DEROctetString(data.getPassword())));
        if (data.getPrincipalName() != null) {
            sequence.add(new DERTaggedObject(1, PrincipalNameEncoder.encode(data.getPrincipalName())));
        }
        if (data.getRealm() != null) {
            sequence.add(new DERTaggedObject(2, DERGeneralString.valueOf(data.getRealm())));
        }
        return sequence;
    }
}

