/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.DirContext;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.jndi.EventListenerAdapter;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.NamingEnumerationAdapter;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.jndi.JndiUtils;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerContext
implements EventContext {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    private final DirectoryService service;
    private final Hashtable<String, Object> env;
    private final DN dn;
    private final Map<NamingListener, DirectoryListener> listeners = new HashMap<NamingListener, DirectoryListener>();
    protected Control[] requestControls = EMPTY_CONTROLS;
    protected Control[] responseControls = EMPTY_CONTROLS;
    protected Control[] connectControls = EMPTY_CONTROLS;
    private final CoreSession session;

    protected ServerContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        this.service = service;
        this.env = env;
        LdapJndiProperties props = LdapJndiProperties.getLdapJndiProperties(this.env);
        this.dn = props.getProviderDn();
        BindOperationContext opContext = this.doBindOperation(props.getBindDn(), props.getCredentials(), props.getSaslMechanism(), props.getSaslAuthId());
        this.session = opContext.getSession();
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
    }

    public ServerContext(DirectoryService service, LdapPrincipal principal, Name name) throws Exception {
        this.service = service;
        this.dn = (DN)DN.fromName(name).clone();
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", this.dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = new DefaultCoreSession(principal, service);
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
    }

    public ServerContext(DirectoryService service, CoreSession session, Name name) throws Exception {
        this.service = service;
        this.dn = (DN)DN.fromName(name).clone();
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", this.dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = session;
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
    }

    protected void injectReferralControl(OperationContext opCtx) {
        if ("ignore".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.ignoreReferral();
        } else if ("throw".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.throwReferral();
        } else {
            opCtx.throwReferral();
        }
    }

    protected void doAddOperation(DN target, ServerEntry entry) throws Exception {
        AddOperationContext opCtx = new AddOperationContext(this.session, entry);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.add(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    protected void doDeleteOperation(DN target) throws Exception {
        DeleteOperationContext opCtx = new DeleteOperationContext(this.session, target);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.delete(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    protected EntryFilteringCursor doSearchOperation(DN dn, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchControls) throws Exception {
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = null;
        Object typesOnlyObj = this.getEnvironment().get("java.naming.ldap.typesOnly");
        boolean typesOnly = false;
        if (typesOnlyObj != null) {
            typesOnly = Boolean.parseBoolean(typesOnlyObj.toString());
        }
        if (searchControls.getSearchScope() == 0 && searchControls.getReturningAttributes() != null && searchControls.getReturningAttributes().length == 0 && filter instanceof EqualityNode) {
            AbstractOperationContext opContext = new CompareOperationContext(this.session, dn, ((EqualityNode)filter).getAttribute(), ((EqualityNode)filter).getValue());
            this.injectReferralControl(opContext);
            boolean result = operationManager.compare((CompareOperationContext)opContext);
            opContext = new SearchOperationContext(this.session, dn, filter, searchControls);
            ((SearchOperationContext)opContext).setAliasDerefMode(aliasDerefMode);
            opContext.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
            ((SearchOperationContext)opContext).setTypesOnly(typesOnly);
            if (result) {
                DefaultServerEntry emptyEntry = new DefaultServerEntry(this.service.getSchemaManager(), DN.EMPTY_DN);
                return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(emptyEntry), (SearchOperationContext)opContext);
            }
            return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), (SearchOperationContext)opContext);
        }
        SearchOperationContext opContext = new SearchOperationContext(this.session, dn, filter, searchControls);
        opContext.setAliasDerefMode(aliasDerefMode);
        opContext.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        opContext.setTypesOnly(typesOnly);
        this.injectReferralControl(opContext);
        results = operationManager.search(opContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opContext.getResponseControls());
        return results;
    }

    protected EntryFilteringCursor doListOperation(DN target) throws Exception {
        ListOperationContext opCtx = new ListOperationContext(this.session, target);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = operationManager.list(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
        return results;
    }

    protected ServerEntry doGetRootDSEOperation(DN target) throws Exception {
        GetRootDSEOperationContext opCtx = new GetRootDSEOperationContext(this.session, target);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        return operationManager.getRootDSE(opCtx);
    }

    protected ServerEntry doLookupOperation(DN target) throws Exception {
        LookupOperationContext opCtx = new LookupOperationContext(this.session, target);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        ClonedServerEntry serverEntry = operationManager.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
        return serverEntry;
    }

    protected ServerEntry doLookupOperation(DN target, String[] attrIds) throws Exception {
        LookupOperationContext opCtx = new LookupOperationContext(this.session, target, attrIds);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        ClonedServerEntry serverEntry = operationManager.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
        if (opCtx.getAttrsId() != null && opCtx.getAttrsId().size() != 0 && serverEntry.get("objectClass") != null && serverEntry.get("objectClass").size() == 0) {
            serverEntry.removeAttributes("objectClass");
        }
        return serverEntry;
    }

    protected BindOperationContext doBindOperation(DN bindDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        BindOperationContext opCtx = new BindOperationContext(null);
        opCtx.setDn(bindDn);
        opCtx.setCredentials(credentials);
        opCtx.setSaslMechanism(saslMechanism);
        opCtx.setSaslAuthId(saslAuthId);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.bind(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
        return opCtx;
    }

    protected void doMoveAndRenameOperation(DN oldDn, DN parent, RDN newRdn, boolean delOldDn) throws Exception {
        MoveAndRenameOperationContext opCtx = new MoveAndRenameOperationContext(this.session, oldDn, parent, new RDN(newRdn), delOldDn);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.moveAndRename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    protected void doModifyOperation(DN dn, List<Modification> modifications) throws Exception {
        ModifyOperationContext opCtx = new ModifyOperationContext(this.session, dn, modifications);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.modify(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    protected void doMove(DN oldDn, DN target) throws Exception {
        MoveOperationContext opCtx = new MoveOperationContext(this.session, oldDn, target);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.move(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    protected void doRename(DN oldDn, RDN newRdn, boolean delOldRdn) throws Exception {
        RenameOperationContext opCtx = new RenameOperationContext(this.session, oldDn, newRdn, delOldRdn);
        opCtx.addRequestControls(JndiUtils.fromJndiControls(this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.rename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(opCtx.getResponseControls());
    }

    public CoreSession getSession() {
        return this.session;
    }

    public DirectoryService getDirectoryService() {
        return this.service;
    }

    public abstract ServerContext getRootContext() throws NamingException;

    public DirectoryService getService() {
        return this.service;
    }

    protected DN getDn() {
        return this.dn;
    }

    @Override
    public void close() throws NamingException {
        for (DirectoryListener listener : this.listeners.values()) {
            try {
                this.service.getEventService().removeListener(listener);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
        this.listeners.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dn.getName();
    }

    public Hashtable<String, Object> getEnvironment() {
        return this.env;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new LdapName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        DN target = this.buildTarget(DN.fromName(name));
        ServerEntry serverEntry = this.service.newEntry(target);
        try {
            serverEntry.add("objectClass", "top", "javaContainer");
        }
        catch (LdapException le) {
            throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
        }
        RDN rdn = target.getRdn();
        if (rdn != null) {
            if (!"cn".equals(rdn.getNormType())) {
                throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
            }
        } else {
            throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
        }
        serverEntry.put(rdn.getUpType(), rdn.getUpValue());
        try {
            this.doAddOperation(target, serverEntry);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), DN.toName(target));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new LdapName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        DN target = this.buildTarget(DN.fromName(name));
        if (target.size() == 0) {
            throw new NoPermissionException(I18n.err(I18n.ERR_492, new Object[0]));
        }
        try {
            this.doDeleteOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new LdapName(name), obj);
    }

    private void injectRdnAttributeValues(DN target, ServerEntry serverEntry) throws NamingException {
        RDN rdn = target.getRdn(target.size() - 1);
        if (rdn.size() == 1) {
            serverEntry.put(rdn.getUpType(), rdn.getNormValue());
        } else {
            for (AVA atav : rdn) {
                serverEntry.put(atav.getUpType(), atav.getNormValue().getString());
            }
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        DN target = this.buildTarget(DN.fromName(name));
        ServerEntry outServerEntry = null;
        try {
            outServerEntry = ServerEntryUtils.toServerEntry(AttributeUtils.toCaseInsensitive(res.getAttributes()), target, this.service.getSchemaManager());
        }
        catch (LdapInvalidAttributeTypeException liate) {
            throw new NamingException(I18n.err(I18n.ERR_495, obj));
        }
        if (outServerEntry != null) {
            try {
                this.doAddOperation(target, outServerEntry);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
            return;
        }
        if (obj instanceof ServerEntry) {
            try {
                this.doAddOperation(target, (ServerEntry)obj);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            if (obj instanceof Referenceable) {
                throw new NamingException(I18n.err(I18n.ERR_493, new Object[0]));
            }
            if (obj instanceof Reference) {
                throw new NamingException(I18n.err(I18n.ERR_494, new Object[0]));
            }
            if (obj instanceof Serializable) {
                ServerEntry serverEntry = this.service.newEntry(target);
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (EntryAttribute serverAttribute : outServerEntry) {
                        try {
                            serverEntry.put(serverAttribute);
                        }
                        catch (LdapException le) {
                            throw new NamingException(I18n.err(I18n.ERR_495, obj));
                        }
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                try {
                    JavaLdapSupport.serialize(serverEntry, obj, this.service.getSchemaManager());
                }
                catch (LdapException le) {
                    throw new NamingException(I18n.err(I18n.ERR_495, obj));
                }
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else if (obj instanceof DirContext) {
                ServerEntry serverEntry = null;
                try {
                    serverEntry = ServerEntryUtils.toServerEntry(((DirContext)obj).getAttributes(""), target, this.service.getSchemaManager());
                }
                catch (LdapInvalidAttributeTypeException liate) {
                    throw new NamingException(I18n.err(I18n.ERR_495, obj));
                }
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (EntryAttribute serverAttribute : outServerEntry) {
                        try {
                            serverEntry.put(serverAttribute);
                        }
                        catch (LdapException le) {
                            throw new NamingException(I18n.err(I18n.ERR_495, obj));
                        }
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else {
                throw new NamingException(I18n.err(I18n.ERR_495, obj));
            }
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new LdapName(oldName), new LdapName(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        DN oldDn = this.buildTarget(DN.fromName(oldName));
        DN newDn = this.buildTarget(DN.fromName(newName));
        if (oldDn.size() == 0) {
            throw new NoPermissionException(I18n.err(I18n.ERR_312, new Object[0]));
        }
        DN oldParent = (DN)oldDn.clone();
        try {
            oldParent.remove(oldDn.size() - 1);
        }
        catch (LdapInvalidDnException lide) {
            throw new NamingException(I18n.err(I18n.ERR_313, lide.getMessage()));
        }
        DN newParent = (DN)newDn.clone();
        try {
            newParent.remove(newDn.size() - 1);
        }
        catch (LdapInvalidDnException lide) {
            throw new NamingException(I18n.err(I18n.ERR_313, lide.getMessage()));
        }
        RDN oldRdn = oldDn.getRdn();
        RDN newRdn = newDn.getRdn();
        boolean delOldRdn = true;
        if (null != this.env.get(DELETE_OLD_RDN_PROP)) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            boolean bl = delOldRdn = !delOldRdnStr.equalsIgnoreCase("false") && !delOldRdnStr.equalsIgnoreCase("no") && !delOldRdnStr.equals("0");
        }
        if (oldParent.equals(newParent)) {
            try {
                this.doRename(oldDn, newRdn, delOldRdn);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else if (newRdn.equals(oldRdn)) {
            try {
                this.doMove(oldDn, newParent);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            try {
                this.doMoveAndRenameOperation(oldDn, newParent, newRdn, delOldRdn);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new LdapName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        DN target = this.buildTarget(DN.fromName(name));
        OperationManager operationManager = this.service.getOperationManager();
        try {
            if (operationManager.hasEntry(new EntryOperationContext(this.session, target))) {
                this.doDeleteOperation(target);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.bind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new LdapName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.doDeleteOperation(this.buildTarget(DN.fromName(name)));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (StringTools.isEmpty(name)) {
            return this.lookup(new LdapName(""));
        }
        return this.lookup(new LdapName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object obj;
        DN target = this.buildTarget(DN.fromName(name));
        ServerEntry serverEntry = null;
        try {
            serverEntry = name.size() == 0 ? this.doGetRootDSEOperation(target) : this.doLookupOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, ServerEntryUtils.toBasicAttributes(serverEntry));
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_497, target);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        if (obj != null) {
            return obj;
        }
        if (serverEntry.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(serverEntry);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), DN.toName(target));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                try {
                    return DN.toName(new DN(name));
                }
                catch (LdapInvalidDnException lide) {
                    throw new InvalidNameException(lide.getMessage());
                }
            }
        };
    }

    @Override
    public NameParser getNameParser(final Name name) throws NamingException {
        return new NameParser(){

            public Name parse(String n) throws NamingException {
                try {
                    return DN.toName(new DN(name.toString()));
                }
                catch (LdapInvalidDnException lide) {
                    throw new InvalidNameException(lide.getMessage());
                }
            }
        };
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new LdapName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        try {
            return new NamingEnumerationAdapter(this.doListOperation(this.buildTarget(DN.fromName(name))));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new LdapName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        DN base = this.buildTarget(DN.fromName(name));
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            return new NamingEnumerationAdapter(this.doSearchOperation(base, aliasDerefMode, filter, ctls));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new LdapName(name), new LdapName(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        DN fqn = this.buildTarget(DN.fromName(name));
        String head = prefix.get(0);
        while (fqn.size() > 0) {
            if (fqn.get(0).equalsIgnoreCase(head)) {
                return DN.toName(fqn);
            }
            try {
                fqn.remove(0);
            }
            catch (LdapInvalidDnException lide) {
                throw new NamingException(lide.getMessage());
            }
        }
        String msg = I18n.err(I18n.ERR_498, prefix, this.dn);
        throw new NamingException(msg);
    }

    @Override
    public void addNamingListener(Name name, int scope, NamingListener namingListener) throws NamingException {
        PresenceNode filter = new PresenceNode("objectClass");
        try {
            EventListenerAdapter listener = new EventListenerAdapter((ServerLdapContext)this, namingListener);
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setFilter(filter);
            criteria.setScope(SearchScope.getSearchScope(scope));
            criteria.setAliasDerefMode(AliasDerefMode.getEnum(this.env));
            criteria.setBase(this.buildTarget(DN.fromName(name)));
            this.service.getEventService().addListener(listener);
            this.listeners.put(namingListener, listener);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void addNamingListener(String name, int scope, NamingListener namingListener) throws NamingException {
        this.addNamingListener(new LdapName(name), scope, namingListener);
    }

    @Override
    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        try {
            DirectoryListener listener = this.listeners.remove(namingListener);
            if (listener != null) {
                this.service.getEventService().removeListener(listener);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    protected Map<NamingListener, DirectoryListener> getListeners() {
        return this.listeners;
    }

    DN buildTarget(DN relativeName) throws NamingException {
        DN target = (DN)this.dn.clone();
        try {
            target.addAllNormalized(target.size(), relativeName);
        }
        catch (LdapInvalidDnException lide) {
            throw new InvalidNameException(lide.getMessage());
        }
        return target;
    }
}

