/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.ArrayList;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizerSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizerSynchronizer.class);

    public NormalizerSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oldOid = this.getOid(entry);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            normalizer.setSchemaName(schemaName);
            this.schemaManager.unregisterNormalizer(oldOid);
            this.schemaManager.add(normalizer);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "Normalizer");
        this.checkOidIsUniqueForNormalizer(entry);
        String schemaName = this.getSchemaName(dn);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (schema.isEnabled() && normalizer.isEnabled()) {
            if (this.schemaManager.add(normalizer)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_364, entry.getDn().getName(), StringTools.listToString(errors));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.schemaManager.getRegistries().associateWithSchema(errors, normalizer);
        if (!errors.isEmpty()) {
            String msg = I18n.err(I18n.ERR_365, entry.getDn().getName(), StringTools.listToString(errors));
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The normalizer {} cannot be added in schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "Normalizer");
        String schemaName = this.getSchemaName(entry.getDn());
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        String oid = normalizer.getOid();
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getRegistries().isReferenced(normalizer)) {
                String msg = I18n.err(I18n.ERR_366, entry.getDn().getName(), this.getReferenced(normalizer));
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
            this.deleteFromSchema(normalizer, schemaName);
        }
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            this.schemaManager.unregisterNormalizer(oid);
            LOG.debug("Removed {} from the enabled schema {}", normalizer, (Object)schemaName);
        } else {
            LOG.debug("Removed {} from the enabled schema {}", normalizer, (Object)schemaName);
        }
    }

    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_367, oldOid));
        }
        String newOid = newRdn.getNormValue();
        this.checkOidIsUniqueForNormalizer(newOid);
        if (this.isSchemaEnabled(schemaName)) {
            ServerEntry targetEntry = (ServerEntry)entry.clone();
            targetEntry.put("m-oid", newOid);
            DN newDn = new DN(targetEntry.getDn());
            newDn.remove(newDn.size() - 1);
            newDn.add(newRdn);
            targetEntry.setDn(newDn);
            Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterNormalizer(oldOid);
            this.schemaManager.add(normalizer);
        }
    }

    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_367, oldOid));
        }
        String oid = newRdn.getNormValue();
        this.checkOidIsUniqueForNormalizer(oid);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterNormalizer(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(normalizer);
        }
    }

    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_368, oid));
        }
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterNormalizer(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(normalizer);
        }
    }

    private void checkOidIsUniqueForNormalizer(String oid) throws Exception {
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_369, oid));
        }
    }

    private void checkOidIsUniqueForNormalizer(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_369, oid));
        }
    }

    private void checkNewParent(DN newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_370, new Object[0]));
        }
        RDN rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_371, new Object[0]));
        }
        if (!rdn.getNormValue().equalsIgnoreCase("normalizers")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_372, new Object[0]));
        }
    }
}

