/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.csn;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.shared.ldap.csn.Csn;

public class CsnFactory {
    private static volatile long lastTimestamp;
    private AtomicInteger changeCount = new AtomicInteger(0);
    private int replicaId;
    private static final int PURGE_INSTANCEID = 4095;

    public CsnFactory(int replicaId) {
        this.replicaId = replicaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Csn newInstance() {
        AtomicInteger atomicInteger = this.changeCount;
        synchronized (atomicInteger) {
            long newTimestamp = System.currentTimeMillis();
            if (lastTimestamp == newTimestamp) {
                this.changeCount.incrementAndGet();
            } else {
                lastTimestamp = newTimestamp;
                this.changeCount.set(0);
            }
        }
        return new Csn(lastTimestamp, this.changeCount.get(), this.replicaId, 0);
    }

    public Csn newInstance(long timestamp, int changeCount) {
        return new Csn(timestamp, changeCount, this.replicaId, 0);
    }

    public Csn newPurgeCsn(long expirationDate) {
        return new Csn(expirationDate, Integer.MAX_VALUE, 4095, Integer.MAX_VALUE);
    }
}

