/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeUsageSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTypeUsageSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public AttributeTypeUsageSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.0.0.3");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < "userApplications".length() || strValue.length() > "userApplications".length()) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        char ch = strValue.charAt(0);
        switch (ch) {
            case 'd': {
                if ("dSAOperation".equals(strValue) || "directoryOperation".equals(strValue) || "distributedOperation".equals(strValue)) {
                    LOG.debug("Syntax valid for '{}'", value);
                    return true;
                }
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            case 'u': {
                boolean comp = "userApplications".equals(strValue);
                if (comp) {
                    LOG.debug("Syntax valid for '{}'", value);
                } else {
                    LOG.debug("Syntax valid for '{}'", value);
                }
                return comp;
            }
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

