/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad;

public enum AdDirSyncFlag {
    DEFAULT(0),
    LDAP_DIRSYNC_OBJECT_SECURITY(1),
    LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER(2048),
    LDAP_DIRSYNC_PUBLIC_DATA_ONLY(8192),
    LDAP_DIRSYNC_INCREMENTAL_VALUES(Integer.MAX_VALUE);

    private int value;

    private AdDirSyncFlag(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AdDirSyncFlag getFlag(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return LDAP_DIRSYNC_OBJECT_SECURITY;
            }
            case 2048: {
                return LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER;
            }
            case 8192: {
                return LDAP_DIRSYNC_PUBLIC_DATA_ONLY;
            }
            case 0x7FFFFFFF: {
                return LDAP_DIRSYNC_INCREMENTAL_VALUES;
            }
        }
        return null;
    }
}

