/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.extendedResponse;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedResponseName
extends GrammarAction<LdapMessageContainer<ExtendedResponseDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedResponseName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreExtendedResponseName() {
        super("Store response name");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedResponseDecorator<?>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04017, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String responseName = Oid.fromString(Strings.asciiBytesToString(tlv.getValue().getData())).toString();
        Object extendedResponse = LdapApiServiceFactory.getSingleton().newExtendedResponse(responseName, container.getMessageId(), null);
        ((ExtendedResponseDecorator)extendedResponse).setLdapResult((LdapResultDecorator)container.getMessage().getLdapResult());
        container.setMessage(LdapApiServiceFactory.getSingleton().decorate((ExtendedResponse)extendedResponse));
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("OID read : {}", (Object)extendedResponse.getResponseName());
        }
    }
}

