/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.changepwd;

import java.io.IOException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.kerberos.ChangePasswordConfig;
import org.apache.directory.server.kerberos.changepwd.protocol.ChangePasswordProtocolHandler;
import org.apache.directory.server.kerberos.kdc.DirectoryPrincipalStore;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCacheImpl;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordServer
extends DirectoryBackedService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordServer.class);
    private static final int DEFAULT_IP_PORT = 464;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final int DEFAULT_CATEGORY_COUNT = 3;
    public static final int DEFAULT_TOKEN_SIZE = 3;
    private ChangePasswordConfig config;
    private ReplayCache replayCache;

    public ChangePasswordServer() {
        this(new ChangePasswordConfig());
    }

    public ChangePasswordServer(ChangePasswordConfig config) {
        this.config = config;
    }

    @Override
    public void start() throws IOException, LdapInvalidDnException {
        DirectoryPrincipalStore store = new DirectoryPrincipalStore(this.getDirectoryService(), new Dn(this.getSearchBaseDn()));
        LOG.debug("initializing the changepassword replay cache");
        this.replayCache = new ReplayCacheImpl(this.config.getAllowableClockSkew());
        for (Transport transport : this.transports) {
            IoAcceptor acceptor = transport.getAcceptor();
            acceptor.setCloseOnDeactivation(false);
            if (transport instanceof UdpTransport) {
                ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
            } else {
                ((SocketAcceptor)acceptor).setReuseAddress(true);
                ((SocketAcceptor)acceptor).getSessionConfig().setTcpNoDelay(true);
            }
            acceptor.setHandler(new ChangePasswordProtocolHandler(this, store));
            acceptor.bind();
        }
        LOG.info("ChangePassword service started.");
    }

    @Override
    public void stop() {
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            if (acceptor == null) continue;
            acceptor.dispose();
        }
        this.replayCache.clear();
        LOG.info("ChangePassword service stopped.");
    }

    public ReplayCache getReplayCache() {
        return this.replayCache;
    }

    public ChangePasswordConfig getConfig() {
        return this.config;
    }

    public int getTcpPort() {
        for (Transport t : this.getTransports()) {
            if (!(t instanceof TcpTransport)) continue;
            return t.getPort();
        }
        throw new IllegalStateException("TCP transport is not enabled");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangePasswordServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

