/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.exception.LdapConfigurationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.api.ldap.model.message.extended.NoticeOfDisconnect;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.security.CertificateUtil;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolHandler;
import org.apache.directory.server.ldap.LdapSessionManager;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.LdapResponseHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.request.AbandonRequestHandler;
import org.apache.directory.server.ldap.handlers.request.AddRequestHandler;
import org.apache.directory.server.ldap.handlers.request.BindRequestHandler;
import org.apache.directory.server.ldap.handlers.request.CompareRequestHandler;
import org.apache.directory.server.ldap.handlers.request.DeleteRequestHandler;
import org.apache.directory.server.ldap.handlers.request.ExtendedRequestHandler;
import org.apache.directory.server.ldap.handlers.request.ModifyDnRequestHandler;
import org.apache.directory.server.ldap.handlers.request.ModifyRequestHandler;
import org.apache.directory.server.ldap.handlers.request.SearchRequestHandler;
import org.apache.directory.server.ldap.handlers.request.UnbindRequestHandler;
import org.apache.directory.server.ldap.handlers.response.AddResponseHandler;
import org.apache.directory.server.ldap.handlers.response.BindResponseHandler;
import org.apache.directory.server.ldap.handlers.response.CompareResponseHandler;
import org.apache.directory.server.ldap.handlers.response.DeleteResponseHandler;
import org.apache.directory.server.ldap.handlers.response.ExtendedResponseHandler;
import org.apache.directory.server.ldap.handlers.response.IntermediateResponseHandler;
import org.apache.directory.server.ldap.handlers.response.ModifyDnResponseHandler;
import org.apache.directory.server.ldap.handlers.response.ModifyResponseHandler;
import org.apache.directory.server.ldap.handlers.response.SearchResultDoneHandler;
import org.apache.directory.server.ldap.handlers.response.SearchResultEntryHandler;
import org.apache.directory.server.ldap.handlers.response.SearchResultReferenceHandler;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.apache.directory.server.ldap.handlers.ssl.LdapsInitializer;
import org.apache.directory.server.ldap.replication.consumer.PingerThread;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationStatusEnum;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.UnorderedThreadPoolExecutor;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LdapServer
extends DirectoryBackedService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapServer.class);
    private static final Logger CONSUMER_LOG = LoggerFactory.getLogger(Loggers.CONSUMER_LOG.getName());
    public static final long NO_SIZE_LIMIT = 0L;
    public static final int NO_TIME_LIMIT = 0;
    public static final String SERVICE_NAME = "ldap";
    private static final long MAX_SIZE_LIMIT_DEFAULT = 100L;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ldap";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS LDAP Service";
    private LdapSessionManager ldapSessionManager = new LdapSessionManager();
    private Set<String> supportedControls;
    private long maxSizeLimit = 100L;
    private int maxTimeLimit = 10000;
    private int maxPDUSize = Integer.MAX_VALUE;
    private String keystoreFile;
    private String certificatePassword;
    private final Collection<ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse>> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse>>();
    private Map<String, MechanismHandler> saslMechanismHandlers = new HashMap<String, MechanismHandler>();
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private Set<String> saslQop;
    private String saslQopString;
    private List<String> saslRealms;
    private LdapRequestHandler<AbandonRequest> abandonRequestHandler;
    private LdapRequestHandler<AddRequest> addRequestHandler;
    private LdapRequestHandler<BindRequest> bindRequestHandler;
    private LdapRequestHandler<CompareRequest> compareRequestHandler;
    private LdapRequestHandler<DeleteRequest> deleteRequestHandler;
    private ExtendedRequestHandler extendedRequestHandler;
    private LdapRequestHandler<ModifyRequest> modifyRequestHandler;
    private LdapRequestHandler<ModifyDnRequest> modifyDnRequestHandler;
    private LdapRequestHandler<SearchRequest> searchRequestHandler;
    private LdapRequestHandler<UnbindRequest> unbindRequestHandler;
    private LdapResponseHandler<AddResponse> addResponseHandler;
    private LdapResponseHandler<BindResponse> bindResponseHandler;
    private LdapResponseHandler<CompareResponse> compareResponseHandler;
    private LdapResponseHandler<DeleteResponse> deleteResponseHandler;
    private ExtendedResponseHandler extendedResponseHandler;
    private LdapResponseHandler<ModifyResponse> modifyResponseHandler;
    private LdapResponseHandler<IntermediateResponse> intermediateResponseHandler;
    private LdapResponseHandler<ModifyDnResponse> modifyDnResponseHandler;
    private LdapResponseHandler<SearchResultEntry> searchResultEntryHandler;
    private LdapResponseHandler<SearchResultReference> searchResultReferenceHandler;
    private LdapResponseHandler<SearchResultDone> searchResultDoneHandler;
    private ProtocolCodecFactory codecFactory = LdapApiServiceFactory.getSingleton().getProtocolCodecFactory();
    private final LdapProtocolHandler handler = new LdapProtocolHandler(this);
    private boolean started;
    private boolean confidentialityRequired;
    private List<IoFilterChainBuilder> chainBuilders = new ArrayList<IoFilterChainBuilder>();
    private ReplicationRequestHandler replicationReqHandler;
    private List<ReplicationConsumer> replConsumers;
    private KeyManagerFactory keyManagerFactory;
    private int pingerSleepTime;
    @Deprecated
    private List<String> enabledCipherSuites = new ArrayList<String>();

    public LdapServer() {
        super.setEnabled(true);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
        this.saslQop = new HashSet<String>();
        this.saslQop.add(SaslQoP.AUTH.getValue());
        this.saslQop.add(SaslQoP.AUTH_INT.getValue());
        this.saslQop.add(SaslQoP.AUTH_CONF.getValue());
        this.saslQopString = SaslQoP.AUTH.getValue() + ',' + SaslQoP.AUTH_INT.getValue() + ',' + SaslQoP.AUTH_CONF.getValue();
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
        this.supportedControls = new HashSet<String>();
    }

    private void installDefaultHandlers() {
        if (this.getAbandonRequestHandler() == null) {
            this.setAbandonHandler(new AbandonRequestHandler());
        }
        if (this.getAddRequestHandler() == null) {
            this.setAddHandlers(new AddRequestHandler(), new AddResponseHandler());
        }
        if (this.getBindRequestHandler() == null) {
            BindRequestHandler bindRequestHandler = new BindRequestHandler();
            bindRequestHandler.setSaslMechanismHandlers(this.saslMechanismHandlers);
            this.setBindHandlers(bindRequestHandler, new BindResponseHandler());
        }
        if (this.getCompareRequestHandler() == null) {
            this.setCompareHandlers(new CompareRequestHandler(), new CompareResponseHandler());
        }
        if (this.getDeleteRequestHandler() == null) {
            this.setDeleteHandlers(new DeleteRequestHandler(), new DeleteResponseHandler());
        }
        if (this.getExtendedRequestHandler() == null) {
            this.setExtendedHandlers(new ExtendedRequestHandler(), new ExtendedResponseHandler());
        }
        if (this.getIntermediateResponseHandler() == null) {
            this.setIntermediateHandler(new IntermediateResponseHandler());
        }
        if (this.getModifyRequestHandler() == null) {
            this.setModifyHandlers(new ModifyRequestHandler(), new ModifyResponseHandler());
        }
        if (this.getModifyDnRequestHandler() == null) {
            this.setModifyDnHandlers(new ModifyDnRequestHandler(), new ModifyDnResponseHandler());
        }
        if (this.getSearchRequestHandler() == null) {
            this.setSearchHandlers(new SearchRequestHandler(), new SearchResultEntryHandler(), new SearchResultReferenceHandler(), new SearchResultDoneHandler());
        }
        if (this.getUnbindRequestHandler() == null) {
            this.setUnbindHandler(new UnbindRequestHandler());
        }
    }

    public void reloadSslContext() throws Exception {
        if (!this.started) {
            return;
        }
        LOG.info("reloading SSL context...");
        this.keyManagerFactory = CertificateUtil.loadKeyStore(this.keystoreFile, this.certificatePassword);
        String sslFilterName = "sslFilter";
        for (IoFilterChainBuilder chainBuilder : this.chainBuilders) {
            DefaultIoFilterChainBuilder dfcb = (DefaultIoFilterChainBuilder)chainBuilder;
            if (!dfcb.contains(sslFilterName)) continue;
            TcpTransport tcpTransport = null;
            for (Transport transport : this.getTransports()) {
                if (!(transport instanceof TcpTransport)) continue;
                tcpTransport = (TcpTransport)transport;
                break;
            }
            DefaultIoFilterChainBuilder newChain = (DefaultIoFilterChainBuilder)LdapsInitializer.init(this, tcpTransport);
            dfcb.replace(sslFilterName, newChain.get(sslFilterName));
            newChain = null;
        }
        StartTlsHandler handler = (StartTlsHandler)this.getExtendedOperationHandler("1.3.6.1.4.1.1466.20037");
        if (handler != null) {
            handler.setLdapServer(this);
        }
        LOG.info("reloaded SSL context successfully");
    }

    @Override
    public void start() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.keyManagerFactory = CertificateUtil.loadKeyStore(this.keystoreFile, this.certificatePassword);
        this.installDefaultHandlers();
        PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
        for (ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> h : this.extendedOperationHandlers) {
            LOG.info("Added Extended Request Handler: {}", (Object)h.getOid());
            h.setLdapServer(this);
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        nexus.registerSupportedSaslMechanisms(this.saslMechanismHandlers.keySet());
        this.startReplicationProducer();
        for (Transport transport : this.transports) {
            if (!(transport instanceof TcpTransport)) {
                LOG.warn("Cannot listen on an UDP transport : {}", (Object)transport);
                continue;
            }
            IoFilterChainBuilder chain = transport.isSSLEnabled() ? LdapsInitializer.init(this, (TcpTransport)transport) : new DefaultIoFilterChainBuilder();
            ((DefaultIoFilterChainBuilder)chain).addLast("codec", new ProtocolCodecFilter(this.getProtocolCodecFactory()));
            ((DefaultIoFilterChainBuilder)chain).addLast("executor", new ExecutorFilter(new UnorderedThreadPoolExecutor(transport.getNbThreads()), IoEventType.MESSAGE_RECEIVED));
            this.startNetwork(transport, chain);
        }
        this.startReplicationConsumers();
        this.started = true;
        LOG.info("Ldap service started.");
    }

    public void startReplicationProducer() {
        if (this.replicationReqHandler != null) {
            this.replicationReqHandler.start(this);
            ((SearchRequestHandler)this.getSearchRequestHandler()).setReplicationReqHandler(this.replicationReqHandler);
        }
    }

    @Override
    public void stop() {
        try {
            for (Transport transport : this.transports) {
                ArrayList<IoSession> sessions;
                if (!(transport instanceof TcpTransport)) continue;
                ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
                try {
                    sessions = new ArrayList<IoSession>(this.getSocketAcceptor(transport).getManagedSessions().values());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Seems like the LDAP service ({}) has already been unbound.", (Object)this.getPort());
                    return;
                }
                this.getSocketAcceptor(transport).dispose();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Unbind of an LDAP service ({}) is complete.", (Object)this.getPort());
                    LOG.info("Sending notice of disconnect to existing clients sessions.");
                }
                if (sessions != null) {
                    for (IoSession session : sessions) {
                        writeFutures.add(session.write(NoticeOfDisconnect.UNAVAILABLE));
                    }
                }
                Iterator sessionIt = sessions.iterator();
                for (WriteFuture future : writeFutures) {
                    future.await(1000L);
                    ((IoSession)sessionIt.next()).closeNow();
                }
                if (this.replicationReqHandler == null) continue;
                this.replicationReqHandler.stop();
            }
            this.stopConsumers();
        }
        catch (Exception e) {
            LOG.warn("Failed to sent NoD.", e);
        }
        this.started = false;
        LOG.info("Ldap service stopped.");
    }

    private void startNetwork(Transport transport, IoFilterChainBuilder chainBuilder) throws Exception {
        if (transport.getBackLog() < 0) {
            transport.setBackLog(50);
        }
        this.chainBuilders.add(chainBuilder);
        try {
            SocketAcceptor acceptor = this.getSocketAcceptor(transport);
            acceptor.setCloseOnDeactivation(false);
            acceptor.getSessionConfig().setTcpNoDelay(true);
            acceptor.setFilterChainBuilder(chainBuilder);
            acceptor.setHandler(this.getHandler());
            ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setReadBufferSize(65536);
            ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setSendBufferSize(65536);
            acceptor.bind();
            this.started = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("Successful bind of an LDAP Service ({}) is completed.", (Object)transport.getPort());
            }
        }
        catch (IOException e) {
            String msg = I18n.err(I18n.ERR_171, transport.getPort());
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setCause(e);
            LOG.error(msg, e);
            throw lce;
        }
    }

    public void startReplicationConsumers() throws Exception {
        if (this.replConsumers != null && !this.replConsumers.isEmpty()) {
            final PingerThread pingerThread = new PingerThread(this.pingerSleepTime);
            pingerThread.start();
            for (final ReplicationConsumer consumer : this.replConsumers) {
                consumer.init(this.getDirectoryService());
                Runnable consumerTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                if (CONSUMER_LOG.isDebugEnabled()) {
                                    MDC.put("Replica", consumer.getId());
                                }
                                LOG.info("starting the replication consumer with {}", (Object)consumer);
                                CONSUMER_LOG.info("starting the replication consumer with {}", (Object)consumer);
                                boolean isConnected = consumer.connect(true);
                                if (!isConnected) continue;
                                pingerThread.addConsumer(consumer);
                                ReplicationStatusEnum status = null;
                                while ((status = consumer.startSync()) == ReplicationStatusEnum.REFRESH_REQUIRED) {
                                }
                                if (status == ReplicationStatusEnum.STOPPED) break;
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Failed to start consumer {}", (Object)consumer);
                            CONSUMER_LOG.error("Failed to start consumer  {}", (Object)consumer);
                            throw new RuntimeException(e);
                        }
                    }
                };
                Thread consumerThread = new Thread(consumerTask);
                consumerThread.setDaemon(true);
                consumerThread.start();
            }
        }
    }

    private void stopConsumers() {
        if (this.replConsumers != null) {
            for (ReplicationConsumer consumer : this.replConsumers) {
                LOG.info("stopping the consumer with id {}", (Object)consumer.getId());
                consumer.stop();
            }
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public LdapSessionManager getLdapSessionManager() {
        return this.ldapSessionManager;
    }

    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.codecFactory;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> eoh) throws LdapException {
        if (this.started) {
            eoh.setLdapServer(this);
            PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
            nexus.registerSupportedExtensions(eoh.getExtensionOids());
        } else {
            this.extendedOperationHandlers.add(eoh);
        }
    }

    public void removeExtendedOperationHandler(String oid) {
        ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> handler = null;
        for (ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> extendedOperationHandler : this.extendedOperationHandlers) {
            if (!extendedOperationHandler.getOid().equals(oid)) continue;
            handler = extendedOperationHandler;
            break;
        }
        this.extendedOperationHandlers.remove(handler);
    }

    public ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> getExtendedOperationHandler(String oid) {
        for (ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> extendedOperationHandler : this.extendedOperationHandlers) {
            if (!extendedOperationHandler.getOid().equals(oid)) continue;
            return extendedOperationHandler;
        }
        return null;
    }

    public void setConfidentialityRequired(boolean confidentialityRequired) {
        this.confidentialityRequired = confidentialityRequired;
    }

    public boolean isConfidentialityRequired() {
        return this.confidentialityRequired;
    }

    public boolean isEnableLdaps(Transport transport) {
        return transport.isSSLEnabled();
    }

    public void setMaxSizeLimit(long maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public long getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection<ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse>> getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse>>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler<ExtendedRequest, ExtendedResponse>> handlers) {
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public String getSaslQopString() {
        return this.saslQopString;
    }

    public Set<String> getSaslQop() {
        return this.saslQop;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Map<String, MechanismHandler> getSaslMechanismHandlers() {
        return this.saslMechanismHandlers;
    }

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> saslMechanismHandlers) {
        this.saslMechanismHandlers = saslMechanismHandlers;
    }

    public MechanismHandler addSaslMechanismHandler(String mechanism, MechanismHandler handler) {
        return this.saslMechanismHandlers.put(mechanism, handler);
    }

    public MechanismHandler removeSaslMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.remove(mechanism);
    }

    public MechanismHandler getMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.get(mechanism);
    }

    public Set<String> getSupportedMechanisms() {
        return this.saslMechanismHandlers.keySet();
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
        super.setDirectoryService(directoryService);
        Iterator<String> itr = directoryService.getLdapCodecService().registeredRequestControls();
        while (itr.hasNext()) {
            this.supportedControls.add(itr.next());
        }
        itr = directoryService.getLdapCodecService().registeredResponseControls();
        while (itr.hasNext()) {
            this.supportedControls.add(itr.next());
        }
    }

    public Set<String> getSupportedControls() {
        return this.supportedControls;
    }

    public MessageHandler<AbandonRequest> getAbandonRequestHandler() {
        return this.abandonRequestHandler;
    }

    public void setAbandonHandler(LdapRequestHandler<AbandonRequest> abandonRequestdHandler) {
        this.handler.removeReceivedMessageHandler(AbandonRequest.class);
        this.abandonRequestHandler = abandonRequestdHandler;
        this.abandonRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(AbandonRequest.class, this.abandonRequestHandler);
    }

    public LdapRequestHandler<AddRequest> getAddRequestHandler() {
        return this.addRequestHandler;
    }

    public LdapResponseHandler<AddResponse> getAddResponseHandler() {
        return this.addResponseHandler;
    }

    public void setAddHandlers(LdapRequestHandler<AddRequest> addRequestHandler, LdapResponseHandler<AddResponse> addResponseHandler) {
        this.handler.removeReceivedMessageHandler(AddRequest.class);
        this.addRequestHandler = addRequestHandler;
        this.addRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(AddRequest.class, this.addRequestHandler);
        this.handler.removeSentMessageHandler(AddResponse.class);
        this.addResponseHandler = addResponseHandler;
        this.addResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(AddResponse.class, this.addResponseHandler);
    }

    public LdapRequestHandler<BindRequest> getBindRequestHandler() {
        return this.bindRequestHandler;
    }

    public LdapResponseHandler<BindResponse> getBindResponseHandler() {
        return this.bindResponseHandler;
    }

    public void setBindHandlers(LdapRequestHandler<BindRequest> bindRequestHandler, LdapResponseHandler<BindResponse> bindResponseHandler) {
        this.handler.removeReceivedMessageHandler(BindRequest.class);
        this.bindRequestHandler = bindRequestHandler;
        this.bindRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(BindRequest.class, this.bindRequestHandler);
        this.handler.removeSentMessageHandler(BindResponse.class);
        this.bindResponseHandler = bindResponseHandler;
        this.bindResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(BindResponse.class, this.bindResponseHandler);
    }

    public LdapRequestHandler<CompareRequest> getCompareRequestHandler() {
        return this.compareRequestHandler;
    }

    public LdapResponseHandler<CompareResponse> getCompareResponseHandler() {
        return this.compareResponseHandler;
    }

    public void setCompareHandlers(LdapRequestHandler<CompareRequest> compareRequestHandler, LdapResponseHandler<CompareResponse> compareResponseHandler) {
        this.handler.removeReceivedMessageHandler(CompareRequest.class);
        this.compareRequestHandler = compareRequestHandler;
        this.compareRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(CompareRequest.class, this.compareRequestHandler);
        this.handler.removeReceivedMessageHandler(CompareResponse.class);
        this.compareResponseHandler = compareResponseHandler;
        this.compareResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(CompareResponse.class, this.compareResponseHandler);
    }

    public LdapRequestHandler<DeleteRequest> getDeleteRequestHandler() {
        return this.deleteRequestHandler;
    }

    public LdapResponseHandler<DeleteResponse> getDeleteResponseHandler() {
        return this.deleteResponseHandler;
    }

    public void setDeleteHandlers(LdapRequestHandler<DeleteRequest> deleteRequestHandler, LdapResponseHandler<DeleteResponse> deleteResponseHandler) {
        this.handler.removeReceivedMessageHandler(DeleteRequest.class);
        this.deleteRequestHandler = deleteRequestHandler;
        this.deleteRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(DeleteRequest.class, this.deleteRequestHandler);
        this.handler.removeSentMessageHandler(DeleteResponse.class);
        this.deleteResponseHandler = deleteResponseHandler;
        this.deleteResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(DeleteResponse.class, this.deleteResponseHandler);
    }

    public LdapRequestHandler<ExtendedRequest> getExtendedRequestHandler() {
        return this.extendedRequestHandler;
    }

    public LdapResponseHandler<ExtendedResponse> getExtendedResponseHandler() {
        return this.extendedResponseHandler;
    }

    public void setExtendedHandlers(ExtendedRequestHandler extendedRequestHandler, ExtendedResponseHandler extendedResponseHandler) {
        this.handler.removeReceivedMessageHandler(ExtendedRequest.class);
        this.extendedRequestHandler = extendedRequestHandler;
        this.extendedRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ExtendedRequest.class, this.extendedRequestHandler);
        this.handler.removeSentMessageHandler(ExtendedResponse.class);
        this.extendedResponseHandler = extendedResponseHandler;
        this.extendedResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(ExtendedResponse.class, this.extendedResponseHandler);
    }

    public LdapResponseHandler<IntermediateResponse> getIntermediateResponseHandler() {
        return this.intermediateResponseHandler;
    }

    public void setIntermediateHandler(LdapResponseHandler<IntermediateResponse> intermediateResponseHandler) {
        this.handler.removeSentMessageHandler(IntermediateResponse.class);
        this.intermediateResponseHandler = intermediateResponseHandler;
        this.intermediateResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(IntermediateResponse.class, this.intermediateResponseHandler);
    }

    public LdapRequestHandler<ModifyRequest> getModifyRequestHandler() {
        return this.modifyRequestHandler;
    }

    public LdapResponseHandler<ModifyResponse> getModifyResponseHandler() {
        return this.modifyResponseHandler;
    }

    public void setModifyHandlers(LdapRequestHandler<ModifyRequest> modifyRequestHandler, LdapResponseHandler<ModifyResponse> modifyResponseHandler) {
        this.handler.removeReceivedMessageHandler(ModifyRequest.class);
        this.modifyRequestHandler = modifyRequestHandler;
        this.modifyRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ModifyRequest.class, this.modifyRequestHandler);
        this.handler.removeSentMessageHandler(ModifyResponse.class);
        this.modifyResponseHandler = modifyResponseHandler;
        this.modifyResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(ModifyResponse.class, this.modifyResponseHandler);
    }

    public LdapRequestHandler<ModifyDnRequest> getModifyDnRequestHandler() {
        return this.modifyDnRequestHandler;
    }

    public LdapResponseHandler<ModifyDnResponse> getModifyDnResponseHandler() {
        return this.modifyDnResponseHandler;
    }

    public void setModifyDnHandlers(LdapRequestHandler<ModifyDnRequest> modifyDnRequestHandler, LdapResponseHandler<ModifyDnResponse> modifyDnResponseHandler) {
        this.handler.removeReceivedMessageHandler(ModifyDnRequest.class);
        this.modifyDnRequestHandler = modifyDnRequestHandler;
        this.modifyDnRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ModifyDnRequest.class, this.modifyDnRequestHandler);
        this.handler.removeSentMessageHandler(ModifyDnResponse.class);
        this.modifyDnResponseHandler = modifyDnResponseHandler;
        this.modifyDnResponseHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(ModifyDnResponse.class, this.modifyDnResponseHandler);
    }

    public LdapRequestHandler<SearchRequest> getSearchRequestHandler() {
        return this.searchRequestHandler;
    }

    public LdapResponseHandler<SearchResultEntry> getSearchResultEntryHandler() {
        return this.searchResultEntryHandler;
    }

    public LdapResponseHandler<SearchResultReference> getSearchResultReferenceHandler() {
        return this.searchResultReferenceHandler;
    }

    public LdapResponseHandler<SearchResultDone> getSearchResultDoneHandler() {
        return this.searchResultDoneHandler;
    }

    public void setSearchHandlers(LdapRequestHandler<SearchRequest> searchRequestHandler, LdapResponseHandler<SearchResultEntry> searchResultEntryHandler, LdapResponseHandler<SearchResultReference> searchResultReferenceHandler, LdapResponseHandler<SearchResultDone> searchResultDoneHandler) {
        this.handler.removeReceivedMessageHandler(SearchRequest.class);
        this.searchRequestHandler = searchRequestHandler;
        this.searchRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(SearchRequest.class, this.searchRequestHandler);
        this.handler.removeSentMessageHandler(SearchResultEntry.class);
        this.searchResultEntryHandler = searchResultEntryHandler;
        this.searchResultEntryHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(SearchResultEntry.class, this.searchResultEntryHandler);
        this.handler.removeSentMessageHandler(SearchResultReference.class);
        this.searchResultReferenceHandler = searchResultReferenceHandler;
        this.searchResultReferenceHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(SearchResultReference.class, this.searchResultReferenceHandler);
        this.handler.removeSentMessageHandler(SearchResultDone.class);
        this.searchResultDoneHandler = searchResultDoneHandler;
        this.searchResultDoneHandler.setLdapServer(this);
        this.handler.addSentMessageHandler(SearchResultDone.class, this.searchResultDoneHandler);
    }

    public LdapRequestHandler<UnbindRequest> getUnbindRequestHandler() {
        return this.unbindRequestHandler;
    }

    public void setUnbindHandler(LdapRequestHandler<UnbindRequest> unbindRequestHandler) {
        this.handler.removeReceivedMessageHandler(UnbindRequest.class);
        this.unbindRequestHandler = unbindRequestHandler;
        this.unbindRequestHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(UnbindRequest.class, this.unbindRequestHandler);
    }

    public int getPort() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    public int getPortSSL() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || !transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public void setReplicationReqHandler(ReplicationRequestHandler replicationProvider) {
        this.replicationReqHandler = replicationProvider;
    }

    public ReplicationRequestHandler getReplicationReqHandler() {
        return this.replicationReqHandler;
    }

    public void setReplConsumers(List<ReplicationConsumer> replConsumers) {
        this.replConsumers = replConsumers;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    public void setMaxPDUSize(int maxPDUSize) {
        if (maxPDUSize <= 0) {
            maxPDUSize = Integer.MAX_VALUE;
        }
        this.maxPDUSize = maxPDUSize;
    }

    public int getReplPingerSleepTime() {
        return this.pingerSleepTime;
    }

    public void setReplPingerSleepTime(int pingerSleepTime) {
        this.pingerSleepTime = pingerSleepTime;
    }

    @Deprecated
    public List<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Deprecated
    public void setEnabledCipherSuites(List<String> enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LdapServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

