/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.TupleBrowser;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.SynchronizedLRUMap;
import org.apache.directory.server.core.avltree.ArrayMarshaller;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirectMarshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyTupleBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.MarshallerSerializerBridge;
import org.apache.directory.server.core.partition.impl.btree.jdbm.NoDupsCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTable;
import org.apache.directory.server.xdbm.KeyTupleArrayCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmTable<K, V>
extends AbstractTable<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmTable.class);
    private static final String SZSUFFIX = "_btree_sz";
    private final RecordManager recMan;
    private BTree<K, V> bt;
    private int numDupLimit = 512;
    private final Map<Long, BTree<K, V>> duplicateBtrees;
    private final Serializer keySerializer;
    private final Serializer valueSerializer;
    Marshaller<ArrayTree<V>> marshaller;

    public JdbmTable(SchemaManager schemaManager, String name, int numDupLimit, RecordManager manager, Comparator<K> keyComparator, Comparator<V> valueComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        super(schemaManager, name, keyComparator, valueComparator);
        if (valueComparator == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_592, (Object[])new Object[0]));
        }
        this.duplicateBtrees = new SynchronizedLRUMap(100);
        this.marshaller = valueSerializer != null ? new ArrayMarshaller(valueComparator, new MarshallerSerializerBridge(valueSerializer)) : new ArrayMarshaller(valueComparator);
        this.numDupLimit = numDupLimit;
        this.recMan = manager;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = true;
        long recId = this.recMan.getNamedObject(name);
        if (recId == 0L) {
            this.bt = new BTree(this.recMan, keyComparator, keySerializer, null);
            recId = this.bt.getRecordId();
            this.recMan.setNamedObject(name, recId);
            recId = this.recMan.insert((Object)0);
            this.recMan.setNamedObject(name + SZSUFFIX, recId);
        } else {
            this.bt = new BTree().load(this.recMan, recId);
            ((SerializableComparator)this.bt.getComparator()).setSchemaManager(schemaManager);
            recId = this.recMan.getNamedObject(name + SZSUFFIX);
            this.count = (Long)this.recMan.fetch(recId);
        }
    }

    public JdbmTable(SchemaManager schemaManager, String name, RecordManager manager, Comparator<K> keyComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        super(schemaManager, name, keyComparator, null);
        this.duplicateBtrees = null;
        this.numDupLimit = Integer.MAX_VALUE;
        this.recMan = manager;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = false;
        long recId = this.recMan.getNamedObject(name);
        if (recId != 0L) {
            this.bt = new BTree().load(this.recMan, recId);
            ((SerializableComparator)this.bt.getComparator()).setSchemaManager(schemaManager);
            this.bt.setValueSerializer(valueSerializer);
            recId = this.recMan.getNamedObject(name + SZSUFFIX);
            Object value = this.recMan.fetch(recId);
            this.count = value instanceof Integer ? ((Integer)value).longValue() : ((Long)value).longValue();
        } else {
            this.bt = new BTree(this.recMan, keyComparator, keySerializer, valueSerializer);
            recId = this.bt.getRecordId();
            this.recMan.setNamedObject(name, recId);
            recId = this.recMan.insert((Object)0);
            this.recMan.setNamedObject(name + SZSUFFIX, recId);
        }
    }

    public Serializer getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    public long greaterThanCount(K key) throws IOException {
        return Math.min(this.count, 10L);
    }

    public long lessThanCount(K key) throws IOException {
        return Math.min(this.count, 10L);
    }

    public long count(K key) throws LdapException {
        if (key == null) {
            return 0L;
        }
        try {
            if (!this.allowsDuplicates) {
                if (null == this.bt.find(key)) {
                    return 0L;
                }
                return 1L;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                return values.getArrayTree().size();
            }
            return this.getBTree(values.getBTreeRedirect()).size();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public V get(K key) throws LdapException {
        if (key == null) {
            return null;
        }
        try {
            if (!this.allowsDuplicates) {
                return (V)this.bt.find(key);
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                if (set.getFirst() == null) {
                    return null;
                }
                return (V)set.getFirst();
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
            TupleBrowser browser = tree.browse();
            browser.getNext(tuple);
            return (V)tuple.getKey();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public boolean hasGreaterOrEqual(K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        try {
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                Object result = set.findGreaterOrEqual(val);
                return result != null;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            return tree.size() != 0 && this.btreeHas(tree, val, true);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public boolean hasLessOrEqual(K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        try {
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                Object result = set.findLessOrEqual(val);
                return result != null;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            return tree.size() != 0 && this.btreeHas(tree, val, false);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public boolean hasGreaterOrEqual(K key) throws IOException {
        jdbm.helper.Tuple tuple = this.bt.findGreaterOrEqual(key);
        if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
            return true;
        }
        return null != tuple;
    }

    public boolean hasLessOrEqual(K key) throws IOException {
        jdbm.helper.Tuple tuple = this.bt.findGreaterOrEqual(key);
        if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
            return true;
        }
        if (null == tuple) {
            return this.count > 0L;
        }
        TupleBrowser browser = this.bt.browse(tuple.getKey());
        return browser.getPrevious(tuple);
    }

    public boolean has(K key, V value) throws LdapException {
        if (key == null) {
            return false;
        }
        try {
            if (!this.allowsDuplicates) {
                Object stored = this.bt.find(key);
                return null != stored && stored.equals(value);
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                return values.getArrayTree().find(value) != null;
            }
            return this.getBTree(values.getBTreeRedirect()).find(value) != null;
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public boolean has(K key) throws IOException {
        return key != null && this.bt.find(key) != null;
    }

    public synchronized void put(K key, V value) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Add {} = {}", (Object)this.name, key);
            }
            if (value == null || key == null) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_594, (Object[])new Object[0]));
            }
            if (!this.allowsDuplicates) {
                Object replaced = this.bt.insert(key, value, true);
                if (null == replaced) {
                    ++this.count;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Add ONE {} = {}", (Object)this.name, key);
                }
                this.commit(this.recMan);
                return;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                Object replaced = set.insert(value);
                if (replaced != null) {
                    return;
                }
                if (set.size() > this.numDupLimit) {
                    BTree<V, K> tree = this.convertToBTree(set);
                    BTreeRedirect redirect = new BTreeRedirect(tree.getRecordId());
                    this.bt.insert(key, (Object)BTreeRedirectMarshaller.INSTANCE.serialize(redirect), true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Add new BTREE {} = {}", (Object)this.name, key);
                    }
                } else {
                    this.bt.insert(key, (Object)this.marshaller.serialize(set), true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Add AVL {} = {}", (Object)this.name, key);
                    }
                }
                ++this.count;
                this.commit(this.recMan);
                return;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            Object replaced = tree.insert(value, (Object)StringConstants.EMPTY_BYTES, true);
            if (replaced == null) {
                ++this.count;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<--- Add BTREE {} = {}", (Object)this.name, key);
            }
            this.commit(this.recMan);
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_131, (Object[])new Object[]{key, this.name}), (Throwable)e);
            throw e;
        }
    }

    public synchronized void remove(K key, V value) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Remove " + this.name + " = " + key + ", " + value);
            }
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove NULL key " + this.name);
                }
                return;
            }
            if (!this.allowsDuplicates) {
                Object oldValue = this.bt.find(key);
                if (oldValue != null && oldValue.equals(value)) {
                    this.bt.remove(key);
                    --this.count;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Remove ONE " + this.name + " = " + key + ", " + value);
                    }
                    this.commit(this.recMan);
                    return;
                }
                return;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                if (set.remove(value) != null) {
                    if (set.isEmpty()) {
                        this.bt.remove(key);
                    } else {
                        this.bt.insert(key, (Object)this.marshaller.serialize(set), true);
                    }
                    --this.count;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Remove AVL " + this.name + " = " + key + ", " + value);
                    }
                    this.commit(this.recMan);
                    return;
                }
                return;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            if (tree.find(value) != null && tree.remove(value) != null) {
                if (tree.size() <= this.numDupLimit) {
                    ArrayTree<V> avlTree = this.convertToArrayTree(tree);
                    this.bt.insert(key, (Object)this.marshaller.serialize(avlTree), true);
                    this.recMan.delete(tree.getRecordId());
                }
                --this.count;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove BTREE " + this.name + " = " + key + ", " + value);
                }
                this.commit(this.recMan);
                return;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_132, (Object[])new Object[]{key, value, this.name}), (Throwable)e);
        }
    }

    public synchronized void remove(K key) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Remove {} = {}", (Object)this.name, key);
            }
            if (key == null) {
                return;
            }
            Object returned = this.bt.remove(key);
            if (null == returned) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove AVL {} = {} (not found)", (Object)this.name, key);
                }
                return;
            }
            if (!this.allowsDuplicates) {
                --this.count;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove ONE {} = {}", (Object)this.name, key);
                }
                this.commit(this.recMan);
                return;
            }
            byte[] serialized = (byte[])returned;
            if (BTreeRedirectMarshaller.isRedirect(serialized)) {
                BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
                this.count -= (long)tree.size();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove BTree {} = {}", (Object)this.name, key);
                }
                this.recMan.delete(tree.getRecordId());
                this.duplicateBtrees.remove(tree.getRecordId());
                this.commit(this.recMan);
                return;
            }
            ArrayTree set = (ArrayTree)this.marshaller.deserialize(serialized);
            this.count -= (long)set.size();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<--- Remove AVL {} = {}", (Object)this.name, key);
            }
            this.commit(this.recMan);
            return;
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_133, (Object[])new Object[]{key, this.name}), (Throwable)e);
            return;
        }
    }

    public Cursor<Tuple<K, V>> cursor() throws LdapException {
        if (this.allowsDuplicates) {
            return new DupsCursor(this);
        }
        return new NoDupsCursor(this);
    }

    public Cursor<Tuple<K, V>> cursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        Object raw = this.bt.find(key);
        if (null == raw) {
            return new EmptyCursor();
        }
        if (!this.allowsDuplicates) {
            return new SingletonCursor((Object)new Tuple(key, raw));
        }
        byte[] serialized = (byte[])raw;
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            return new KeyTupleBTreeCursor(tree, key, this.valueComparator);
        }
        ArrayTree set = (ArrayTree)this.marshaller.deserialize(serialized);
        return new KeyTupleArrayCursor(set, key);
    }

    public Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        Object raw = this.bt.find(key);
        if (null == raw) {
            return new EmptyCursor();
        }
        if (!this.allowsDuplicates) {
            return new SingletonCursor(raw);
        }
        byte[] serialized = (byte[])raw;
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            return new KeyBTreeCursor(tree, this.valueComparator);
        }
        return new ArrayTreeCursor((ArrayTree)this.marshaller.deserialize(serialized));
    }

    public synchronized void close() throws IOException {
        this.sync();
    }

    public synchronized void sync() throws IOException {
        long recId = this.recMan.getNamedObject(this.name + SZSUFFIX);
        this.recMan.update(recId, (Object)this.count);
        this.recMan.commit();
        if (this.commitNumber.get() % 4000 == 0) {
            BaseRecordManager baseRecordManager = null;
            baseRecordManager = this.recMan instanceof CacheRecordManager ? (BaseRecordManager)((CacheRecordManager)this.recMan).getRecordManager() : (BaseRecordManager)this.recMan;
            baseRecordManager.getTransactionManager().synchronizeLog();
        }
    }

    public Marshaller<ArrayTree<V>> getMarshaller() {
        return this.marshaller;
    }

    boolean isKeyUsingBTree(K key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!this.allowsDuplicates) {
            return false;
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        return values.isBTreeRedirect();
    }

    DupsContainer<V> getDupsContainer(byte[] serialized) throws LdapException {
        if (serialized == null) {
            return new DupsContainer(new ArrayTree(this.valueComparator));
        }
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            try {
                return new DupsContainer(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage());
            }
        }
        try {
            return new DupsContainer((ArrayTree)this.marshaller.deserialize(serialized));
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    BTree getBTree() {
        return this.bt;
    }

    BTree getBTree(BTreeRedirect redirect) throws IOException {
        if (this.duplicateBtrees.containsKey(redirect.getRecId())) {
            return this.duplicateBtrees.get(redirect.getRecId());
        }
        BTree tree = new BTree().load(this.recMan, redirect.getRecId());
        ((SerializableComparator)tree.getComparator()).setSchemaManager(this.schemaManager);
        this.duplicateBtrees.put(redirect.getRecId(), tree);
        return tree;
    }

    private boolean btreeHas(BTree tree, V key, boolean isGreaterThan) throws IOException {
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        TupleBrowser browser = tree.browse(key);
        if (isGreaterThan) {
            return browser.getNext(tuple);
        }
        if (browser.getPrevious(tuple)) {
            return true;
        }
        browser.getNext(tuple);
        Object firstKey = tuple.getKey();
        return this.valueComparator.compare(key, firstKey) == 0;
    }

    private ArrayTree<V> convertToArrayTree(BTree bTree) throws IOException {
        ArrayTree avlTree = new ArrayTree(this.valueComparator);
        TupleBrowser browser = bTree.browse();
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        while (browser.getNext(tuple)) {
            avlTree.insert(tuple.getKey());
        }
        return avlTree;
    }

    private BTree<V, K> convertToBTree(ArrayTree<V> arrayTree) throws Exception {
        BTree bTree = this.valueSerializer != null ? new BTree(this.recMan, this.valueComparator, this.valueSerializer, null) : new BTree(this.recMan, this.valueComparator);
        ArrayTreeCursor keys = new ArrayTreeCursor(arrayTree);
        keys.beforeFirst();
        while (keys.next()) {
            bTree.insert(keys.get(), (Object)StringConstants.EMPTY_BYTES, true);
        }
        keys.close();
        return bTree;
    }

    private void commit(RecordManager recordManager) throws IOException {
        if (this.commitNumber.incrementAndGet() % 2000 == 0) {
            this.sync();
        }
    }
}

