/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.directory.server.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteArrayComparator
implements Comparator<byte[]>,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public int compare(byte[] obj1, byte[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_525, (Object[])new Object[0]));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_526, (Object[])new Object[0]));
        }
        return ByteArrayComparator.compareByteArray(obj1, obj2);
    }

    public static int compareByteArray(byte[] thisKey, byte[] otherKey) {
        int len = Math.min(thisKey.length, otherKey.length);
        for (int i = 0; i < len; ++i) {
            if (thisKey[i] >= 0) {
                if (otherKey[i] >= 0) {
                    if (thisKey[i] < otherKey[i]) {
                        return -1;
                    }
                    if (thisKey[i] <= otherKey[i]) continue;
                    return 1;
                }
                return -1;
            }
            if (otherKey[i] >= 0) {
                return 1;
            }
            if (thisKey[i] < otherKey[i]) {
                return -1;
            }
            if (thisKey[i] <= otherKey[i]) continue;
            return 1;
        }
        if (thisKey.length == otherKey.length) {
            return 0;
        }
        if (thisKey.length < otherKey.length) {
            return -1;
        }
        return 1;
    }
}

