/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.PaData;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.messages.KerberosMessage;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.apache.directory.shared.util.Strings;

public class KdcRep
extends KerberosMessage {
    private List<PaData> paData = new ArrayList<PaData>();
    private String crealm;
    private byte[] crealmBytes;
    private PrincipalName cname;
    private Ticket ticket;
    private EncryptedData encPart;
    protected EncKdcRepPart encKdcRepPart;
    private int pvnoLength;
    private int msgTypeLength;
    private int paDataLength;
    private int paDataSeqLength;
    private int[] paDataLengths;
    private int cnameLength;
    private int crealmLength;
    private int ticketLength;
    private int encPartLength;
    private int kdcRepSeqLength;
    private int kdcRepLength;

    public KdcRep(KerberosMessageType msgType) {
        super(msgType);
    }

    public int getPvno() {
        return this.getProtocolVersionNumber();
    }

    public void setPvno(int pvno) {
        this.setProtocolVersionNumber(pvno);
    }

    public List<PaData> getPaData() {
        return this.paData;
    }

    public void addPaData(PaData paData) {
        this.paData.add(paData);
    }

    public String getCRealm() {
        return this.crealm;
    }

    public void setCRealm(String crealm) {
        this.crealm = crealm;
    }

    public PrincipalName getCName() {
        return this.cname;
    }

    public void setCName(PrincipalName cname) {
        this.cname = cname;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public void setEncPart(EncryptedData encPart) {
        this.encPart = encPart;
    }

    public EncKdcRepPart getEncKdcRepPart() {
        return this.encKdcRepPart;
    }

    public void setEncKdcRepPart(EncKdcRepPart encKdcRepPart) {
        this.encKdcRepPart = encKdcRepPart;
    }

    public int computeLength() {
        this.pvnoLength = 3;
        this.kdcRepSeqLength = 1 + TLV.getNbBytes((int)this.pvnoLength) + this.pvnoLength;
        this.msgTypeLength = 3;
        this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.msgTypeLength) + this.msgTypeLength;
        if (this.paData.size() != 0) {
            this.paDataLengths = new int[this.paData.size()];
            int pos = 0;
            this.paDataSeqLength = 0;
            for (PaData paDataElem : this.paData) {
                this.paDataLengths[pos] = paDataElem.computeLength();
                this.paDataSeqLength += this.paDataLengths[pos];
                ++pos;
            }
            this.paDataLength = 1 + TLV.getNbBytes((int)this.paDataSeqLength) + this.paDataSeqLength;
            this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.paDataLength) + this.paDataLength;
        }
        this.crealmBytes = Strings.getBytesUtf8((String)this.crealm);
        this.crealmLength = 1 + TLV.getNbBytes((int)this.crealmBytes.length) + this.crealmBytes.length;
        this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.crealmLength) + this.crealmLength;
        this.cnameLength = this.cname.computeLength();
        this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.cnameLength) + this.cnameLength;
        this.ticketLength = this.ticket.computeLength();
        this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.ticketLength) + this.ticketLength;
        this.encPartLength = this.encPart.computeLength();
        this.kdcRepSeqLength += 1 + TLV.getNbBytes((int)this.encPartLength) + this.encPartLength;
        this.kdcRepLength = 1 + TLV.getNbBytes((int)this.kdcRepSeqLength) + this.kdcRepSeqLength;
        return this.kdcRepLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_148, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.kdcRepSeqLength));
        buffer.put((byte)-96);
        buffer.put(TLV.getBytes((int)this.pvnoLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getProtocolVersionNumber());
        buffer.put((byte)-95);
        buffer.put(TLV.getBytes((int)this.msgTypeLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getMessageType().getValue());
        if (this.paData.size() != 0) {
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.paDataLength));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.paDataSeqLength));
            for (PaData paDataElem : this.paData) {
                paDataElem.encode(buffer);
            }
        }
        buffer.put((byte)-93);
        buffer.put(TLV.getBytes((int)this.crealmLength));
        buffer.put(UniversalTag.GENERAL_STRING.getValue());
        buffer.put(TLV.getBytes((int)this.crealmBytes.length));
        buffer.put(this.crealmBytes);
        buffer.put((byte)-92);
        buffer.put(TLV.getBytes((int)this.cnameLength));
        this.cname.encode(buffer);
        buffer.put((byte)-91);
        buffer.put(TLV.getBytes((int)this.ticketLength));
        this.ticket.encode(buffer);
        buffer.put((byte)-90);
        buffer.put(TLV.getBytes((int)this.encPartLength));
        this.encPart.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getMessageType() == KerberosMessageType.AS_REP) {
            sb.append("AS-REP").append('\n');
        } else if (this.getMessageType() == KerberosMessageType.TGS_REP) {
            sb.append("TGS-REP").append('\n');
        } else {
            sb.append("Unknown").append('\n');
        }
        sb.append("pvno : ").append(this.getProtocolVersionNumber()).append('\n');
        sb.append("msg-type : ");
        for (PaData paDataElem : this.paData) {
            sb.append("padata : ").append((Object)paDataElem).append('\n');
        }
        sb.append("crealm : ").append(this.crealm).append('\n');
        sb.append("cname : ").append((Object)this.cname).append('\n');
        sb.append("ticket : ").append((Object)this.ticket).append('\n');
        sb.append("enc-part : ").append((Object)this.encPart).append('\n');
        return sb.toString();
    }
}

