/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponseRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteHandler
extends LdapRequestHandler<DeleteRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteHandler.class);

    @Override
    public void handle(LdapSession session, DeleteRequest req) {
        LOG.debug("Handling request: {}", (Object)req);
        LdapResult result = ((DeleteResponse)req.getResultResponse()).getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.delete(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, (ResultResponseRequest<?>)req, e);
        }
    }
}

