/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

public abstract class AdsBaseBean {
    @ConfigurationElement(attributeType="ads-enabled")
    private boolean enabled = true;
    @ConfigurationElement(attributeType="description")
    private String description;
    private Dn dn;

    protected AdsBaseBean() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected String toString(String tabs, String name, boolean value) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append(name).append(" : ");
        if (value) {
            sb.append("TRUE");
        } else {
            sb.append("FALSE");
        }
        sb.append('\n');
        return sb.toString();
    }

    protected String toString(String tabs, String name, String value) {
        if (value != null) {
            return tabs + name + " : " + value + "\n";
        }
        return "";
    }

    protected String toString(String tabs, String name, Dn value) {
        if (value != null) {
            return tabs + name + " : " + value.getName() + "\n";
        }
        return "";
    }

    public final boolean isDisabled() {
        return !this.enabled;
    }

    protected String toString(String tabs, String name, long value) {
        return tabs + name + " : " + value + "\n";
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString(tabs, "enabled", this.enabled));
        if (!Strings.isEmpty((String)this.description)) {
            sb.append(tabs).append("description : '").append(this.description).append("'\n");
        }
        if (this.dn != null) {
            sb.append(tabs).append("DN: ").append(this.dn).append("'\n");
        }
        return sb.toString();
    }

    public void setDn(Dn dn) {
        this.dn = dn;
    }

    public Dn getDn() {
        return this.dn;
    }

    public String toString() {
        return this.toString("");
    }
}

