/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.avl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.partition.impl.xdbm.AbstractXdbmPartition;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlStore;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlPartition
extends AbstractXdbmPartition<Long> {
    private Set<AvlIndex<?, Entry>> indexedAttributes = new HashSet();

    public AvlPartition() {
        super(new AvlStore<Entry>());
    }

    protected void doInit() throws Exception {
        this.setSchemaManager(this.schemaManager);
        EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.store, this.schemaManager);
        CursorBuilder cursorBuilder = new CursorBuilder(this.store, evaluatorBuilder);
        this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer(this.store);
        this.searchEngine = new DefaultSearchEngine(this.store, cursorBuilder, evaluatorBuilder, this.optimizer);
        if (this.store.isInitialized()) {
            return;
        }
        this.store.setId(this.getId());
        this.suffix.apply(this.schemaManager);
        this.store.setSuffixDn(this.suffix);
        for (AvlIndex<?, Entry> index : this.indexedAttributes) {
            String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
            if (!index.getAttributeId().equals(oid)) {
                index.setAttributeId(oid);
            }
            this.store.addIndex(index);
        }
        this.store.init(this.schemaManager);
    }

    public final void modify(Dn dn, List<Modification> modifications) throws LdapException {
        try {
            this.store.modify(dn, modifications);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public AvlStore<Entry> getStore() {
        return (AvlStore)this.store;
    }

    @Override
    protected void doDestroy() throws Exception {
        this.store.destroy();
    }
}

