/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.net.URI;
import java.util.Comparator;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.xdbm.AbstractStore;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlMasterTable;
import org.apache.directory.server.xdbm.impl.avl.AvlRdnIndex;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlStore<E>
extends AbstractStore<E, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AvlStore.class);

    @Override
    public void destroy() throws Exception {
        this.initialized = false;
        if (this.master != null) {
            this.master.close();
        }
        for (Index idx : this.systemIndices.values()) {
            idx.close();
        }
        for (Index idx : this.userIndices.values()) {
            idx.close();
        }
    }

    @Override
    public void init(SchemaManager schemaManager) throws Exception {
        super.init(schemaManager);
        this.master = new AvlMasterTable(this.id, (Comparator<Long>)((Object)new LongComparator()), null, false);
        this.setupSystemIndices();
        this.setupUserIndices();
        this.initialized = true;
    }

    @Override
    protected Index<?, E, Long> convertAndInit(Index<?, E, Long> index) throws Exception {
        AvlIndex avlIndex;
        if (index.getAttributeId().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            avlIndex = new AvlRdnIndex(index.getAttributeId());
        } else if (index instanceof AvlIndex) {
            avlIndex = (AvlIndex)index;
        } else {
            LOG.debug("Supplied index {} is not a AvlIndex.  Will create new AvlIndex using copied configuration parameters.", index);
            avlIndex = new AvlIndex(index.getAttributeId());
        }
        ((AvlIndex)avlIndex).init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return avlIndex;
    }

    @Override
    public int getCacheSize() {
        return 0;
    }

    @Override
    public URI getPartitionPath() {
        return null;
    }

    @Override
    public boolean isSyncOnWrite() {
        return false;
    }

    @Override
    public void sync() throws Exception {
    }

    @Override
    public Long getDefaultId() {
        return 1L;
    }

    @Override
    protected Long getRootId() {
        return 0L;
    }
}

