/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.AndEvaluator;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.NotEvaluator;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.OrEvaluator;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.exception.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorBuilder<ID extends Comparable<ID>> {
    private final Store<Entry, ID> db;
    private final SchemaManager schemaManager;

    public EvaluatorBuilder(Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.schemaManager = schemaManager;
    }

    public <T> Evaluator<? extends ExprNode, Entry, ID> build(ExprNode node) throws Exception {
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return new ApproximateEvaluator((ApproximateNode)node, this.db, this.schemaManager);
            }
            case EQUALITY: {
                return new EqualityEvaluator((EqualityNode)node, this.db, this.schemaManager);
            }
            case GREATEREQ: {
                return new GreaterEqEvaluator((GreaterEqNode)node, this.db, this.schemaManager);
            }
            case LESSEQ: {
                return new LessEqEvaluator((LessEqNode)node, this.db, this.schemaManager);
            }
            case PRESENCE: {
                return new PresenceEvaluator<ID>((PresenceNode)node, this.db, this.schemaManager);
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return new OneLevelScopeEvaluator<Entry, ID>(this.db, (ScopeNode)node);
                }
                return new SubtreeScopeEvaluator<Entry, ID>(this.db, (ScopeNode)node);
            }
            case SUBSTRING: {
                return new SubstringEvaluator<ID>((SubstringNode)node, this.db, this.schemaManager);
            }
            case AND: {
                return this.buildAndEvaluator((AndNode)node);
            }
            case NOT: {
                return new NotEvaluator<ID>((NotNode)node, this.build(((NotNode)node).getFirstChild()));
            }
            case OR: {
                return this.buildOrEvaluator((OrNode)node);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_260, (Object[])new Object[]{node.getAssertionType()}));
    }

    AndEvaluator<ID> buildAndEvaluator(AndNode node) throws Exception {
        List children = node.getChildren();
        ArrayList evaluators = new ArrayList(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new AndEvaluator(node, evaluators);
    }

    OrEvaluator<ID> buildOrEvaluator(OrNode node) throws Exception {
        List children = node.getChildren();
        ArrayList evaluators = new ArrayList(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new OrEvaluator(node, evaluators);
    }
}

