/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.LdapRequestDecorator;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.dom4j.Element;

public abstract class AbstractRequestDsml
extends LdapRequestDecorator
implements DsmlDecorator {
    public AbstractRequestDsml(LdapMessageCodec ldapMessage) {
        super(ldapMessage);
    }

    public Element toDsml(Element root) {
        Element element = root.addElement(this.getRequestName());
        int requestID = this.instance.getMessageId();
        if (requestID != 0) {
            element.addAttribute("requestID", "" + requestID);
        }
        ParserUtils.addControls(element, this.instance.getControls());
        return element;
    }

    private String getRequestName() {
        switch (this.instance.getMessageType()) {
            case ABANDON_REQUEST: {
                return "abandonRequest";
            }
            case ADD_REQUEST: {
                return "addRequest";
            }
            case BIND_REQUEST: {
                return "authRequest";
            }
            case COMPARE_REQUEST: {
                return "compareRequest";
            }
            case DEL_REQUEST: {
                return "delRequest";
            }
            case EXTENDED_REQUEST: {
                return "extendedRequest";
            }
            case MODIFYDN_REQUEST: {
                return "modDNRequest";
            }
            case MODIFY_REQUEST: {
                return "modifyRequest";
            }
            case SEARCH_REQUEST: {
                return "searchRequest";
            }
        }
        return "error";
    }
}

