/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.AbstractSingleBuilder;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="groupingaggregate")
public class GroupingAggregate
extends SingleInputOperator {
    static final Logger logger = LoggerFactory.getLogger(GroupingAggregate.class);
    private final List<NamedExpression> keys;
    private final List<NamedExpression> exprs;

    public GroupingAggregate(@JsonProperty(value="keys") List<NamedExpression> keys, @JsonProperty(value="exprs") List<NamedExpression> exprs) {
        this.keys = keys;
        this.exprs = exprs;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitGroupingAggregate(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator((Object)this.getInput());
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<NamedExpression> getKeys() {
        return this.keys;
    }

    public List<NamedExpression> getExprs() {
        return this.exprs;
    }

    public static class Builder
    extends AbstractSingleBuilder<GroupingAggregate, Builder> {
        private List<NamedExpression> keys = Lists.newArrayList();
        private List<NamedExpression> exprs = Lists.newArrayList();

        public Builder addKey(FieldReference ref, LogicalExpression expr) {
            this.keys.add(new NamedExpression(expr, ref));
            return this;
        }

        public Builder addKey(NamedExpression expr) {
            this.keys.add(expr);
            return this;
        }

        public Builder addExpr(NamedExpression expr) {
            this.exprs.add(expr);
            return this;
        }

        public Builder addExpr(FieldReference ref, LogicalExpression expr) {
            this.exprs.add(new NamedExpression(expr, ref));
            return this;
        }

        @Override
        public GroupingAggregate internalBuild() {
            GroupingAggregate ga = new GroupingAggregate(this.keys, this.exprs);
            return ga;
        }
    }
}

