/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.data.AbstractBuilder;
import org.apache.drill.common.logical.data.SourceOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="scan")
public class Scan
extends SourceOperator {
    private final String storageEngine;
    private final JSONOptions selection;

    @JsonCreator
    public Scan(@JsonProperty(value="storageengine") String storageEngine, @JsonProperty(value="selection") JSONOptions selection) {
        this.storageEngine = storageEngine;
        this.selection = selection;
    }

    @JsonProperty(value="storageengine")
    public String getStorageEngine() {
        return this.storageEngine;
    }

    public JSONOptions getSelection() {
        return this.selection;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitScan(this, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Scan> {
        private String storageEngine;
        private JSONOptions selection;

        public Builder storageEngine(String storageEngine) {
            this.storageEngine = storageEngine;
            return this;
        }

        public Builder selection(JSONOptions selection) {
            this.selection = selection;
            return this;
        }

        @Override
        public Scan build() {
            return new Scan(this.storageEngine, this.selection);
        }
    }
}

