/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto.beans;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.exec.proto.beans.Collector;
import org.apache.drill.exec.proto.beans.DrillbitEndpoint;
import org.apache.drill.exec.proto.beans.FragmentHandle;
import org.apache.drill.exec.proto.beans.QueryContextInformation;
import org.apache.drill.exec.proto.beans.UserCredentials;

public final class PlanFragment
implements Externalizable,
Message<PlanFragment>,
Schema<PlanFragment> {
    static final PlanFragment DEFAULT_INSTANCE = new PlanFragment();
    static final long DEFAULT_MEM_INITIAL = 20000000L;
    static final long DEFAULT_MEM_MAX = 2000000000L;
    private FragmentHandle handle;
    private float networkCost;
    private float cpuCost;
    private float diskCost;
    private float memoryCost;
    private String fragmentJson;
    private Boolean leafFragment;
    private DrillbitEndpoint assignment;
    private DrillbitEndpoint foreman;
    private long memInitial = 20000000L;
    private long memMax = 2000000000L;
    private UserCredentials credentials;
    private String optionsJson;
    private QueryContextInformation context;
    private List<Collector> collector;
    private static final HashMap<String, Integer> __fieldMap = new HashMap();

    public static Schema<PlanFragment> getSchema() {
        return DEFAULT_INSTANCE;
    }

    public static PlanFragment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public FragmentHandle getHandle() {
        return this.handle;
    }

    public PlanFragment setHandle(FragmentHandle handle) {
        this.handle = handle;
        return this;
    }

    public float getNetworkCost() {
        return this.networkCost;
    }

    public PlanFragment setNetworkCost(float networkCost) {
        this.networkCost = networkCost;
        return this;
    }

    public float getCpuCost() {
        return this.cpuCost;
    }

    public PlanFragment setCpuCost(float cpuCost) {
        this.cpuCost = cpuCost;
        return this;
    }

    public float getDiskCost() {
        return this.diskCost;
    }

    public PlanFragment setDiskCost(float diskCost) {
        this.diskCost = diskCost;
        return this;
    }

    public float getMemoryCost() {
        return this.memoryCost;
    }

    public PlanFragment setMemoryCost(float memoryCost) {
        this.memoryCost = memoryCost;
        return this;
    }

    public String getFragmentJson() {
        return this.fragmentJson;
    }

    public PlanFragment setFragmentJson(String fragmentJson) {
        this.fragmentJson = fragmentJson;
        return this;
    }

    public Boolean getLeafFragment() {
        return this.leafFragment;
    }

    public PlanFragment setLeafFragment(Boolean leafFragment) {
        this.leafFragment = leafFragment;
        return this;
    }

    public DrillbitEndpoint getAssignment() {
        return this.assignment;
    }

    public PlanFragment setAssignment(DrillbitEndpoint assignment) {
        this.assignment = assignment;
        return this;
    }

    public DrillbitEndpoint getForeman() {
        return this.foreman;
    }

    public PlanFragment setForeman(DrillbitEndpoint foreman) {
        this.foreman = foreman;
        return this;
    }

    public long getMemInitial() {
        return this.memInitial;
    }

    public PlanFragment setMemInitial(long memInitial) {
        this.memInitial = memInitial;
        return this;
    }

    public long getMemMax() {
        return this.memMax;
    }

    public PlanFragment setMemMax(long memMax) {
        this.memMax = memMax;
        return this;
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }

    public PlanFragment setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public String getOptionsJson() {
        return this.optionsJson;
    }

    public PlanFragment setOptionsJson(String optionsJson) {
        this.optionsJson = optionsJson;
        return this;
    }

    public QueryContextInformation getContext() {
        return this.context;
    }

    public PlanFragment setContext(QueryContextInformation context) {
        this.context = context;
        return this;
    }

    public List<Collector> getCollectorList() {
        return this.collector;
    }

    public PlanFragment setCollectorList(List<Collector> collector) {
        this.collector = collector;
        return this;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        GraphIOUtil.mergeDelimitedFrom((DataInput)in, (Object)this, (Schema)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        GraphIOUtil.writeDelimitedTo((DataOutput)out, (Object)this, (Schema)this);
    }

    public Schema<PlanFragment> cachedSchema() {
        return DEFAULT_INSTANCE;
    }

    public PlanFragment newMessage() {
        return new PlanFragment();
    }

    public Class<PlanFragment> typeClass() {
        return PlanFragment.class;
    }

    public String messageName() {
        return PlanFragment.class.getSimpleName();
    }

    public String messageFullName() {
        return PlanFragment.class.getName();
    }

    public boolean isInitialized(PlanFragment message) {
        return true;
    }

    public void mergeFrom(Input input, PlanFragment message) throws IOException {
        int number = input.readFieldNumber((Schema)this);
        while (true) {
            switch (number) {
                case 0: {
                    return;
                }
                case 1: {
                    message.handle = (FragmentHandle)input.mergeObject((Object)message.handle, FragmentHandle.getSchema());
                    break;
                }
                case 4: {
                    message.networkCost = input.readFloat();
                    break;
                }
                case 5: {
                    message.cpuCost = input.readFloat();
                    break;
                }
                case 6: {
                    message.diskCost = input.readFloat();
                    break;
                }
                case 7: {
                    message.memoryCost = input.readFloat();
                    break;
                }
                case 8: {
                    message.fragmentJson = input.readString();
                    break;
                }
                case 9: {
                    message.leafFragment = input.readBool();
                    break;
                }
                case 10: {
                    message.assignment = (DrillbitEndpoint)input.mergeObject((Object)message.assignment, DrillbitEndpoint.getSchema());
                    break;
                }
                case 11: {
                    message.foreman = (DrillbitEndpoint)input.mergeObject((Object)message.foreman, DrillbitEndpoint.getSchema());
                    break;
                }
                case 12: {
                    message.memInitial = input.readInt64();
                    break;
                }
                case 13: {
                    message.memMax = input.readInt64();
                    break;
                }
                case 14: {
                    message.credentials = (UserCredentials)input.mergeObject((Object)message.credentials, UserCredentials.getSchema());
                    break;
                }
                case 15: {
                    message.optionsJson = input.readString();
                    break;
                }
                case 16: {
                    message.context = (QueryContextInformation)input.mergeObject((Object)message.context, QueryContextInformation.getSchema());
                    break;
                }
                case 17: {
                    if (message.collector == null) {
                        message.collector = new ArrayList<Collector>();
                    }
                    message.collector.add((Collector)input.mergeObject(null, Collector.getSchema()));
                    break;
                }
                default: {
                    input.handleUnknownField(number, (Schema)this);
                }
            }
            number = input.readFieldNumber((Schema)this);
        }
    }

    public void writeTo(Output output, PlanFragment message) throws IOException {
        if (message.handle != null) {
            output.writeObject(1, (Object)message.handle, FragmentHandle.getSchema(), false);
        }
        if (message.networkCost != 0.0f) {
            output.writeFloat(4, message.networkCost, false);
        }
        if (message.cpuCost != 0.0f) {
            output.writeFloat(5, message.cpuCost, false);
        }
        if (message.diskCost != 0.0f) {
            output.writeFloat(6, message.diskCost, false);
        }
        if (message.memoryCost != 0.0f) {
            output.writeFloat(7, message.memoryCost, false);
        }
        if (message.fragmentJson != null) {
            output.writeString(8, message.fragmentJson, false);
        }
        if (message.leafFragment != null) {
            output.writeBool(9, message.leafFragment.booleanValue(), false);
        }
        if (message.assignment != null) {
            output.writeObject(10, (Object)message.assignment, DrillbitEndpoint.getSchema(), false);
        }
        if (message.foreman != null) {
            output.writeObject(11, (Object)message.foreman, DrillbitEndpoint.getSchema(), false);
        }
        if (message.memInitial != 20000000L) {
            output.writeInt64(12, message.memInitial, false);
        }
        if (message.memMax != 2000000000L) {
            output.writeInt64(13, message.memMax, false);
        }
        if (message.credentials != null) {
            output.writeObject(14, (Object)message.credentials, UserCredentials.getSchema(), false);
        }
        if (message.optionsJson != null) {
            output.writeString(15, message.optionsJson, false);
        }
        if (message.context != null) {
            output.writeObject(16, (Object)message.context, QueryContextInformation.getSchema(), false);
        }
        if (message.collector != null) {
            for (Collector collector : message.collector) {
                if (collector == null) continue;
                output.writeObject(17, (Object)collector, Collector.getSchema(), true);
            }
        }
    }

    public String getFieldName(int number) {
        switch (number) {
            case 1: {
                return "handle";
            }
            case 4: {
                return "networkCost";
            }
            case 5: {
                return "cpuCost";
            }
            case 6: {
                return "diskCost";
            }
            case 7: {
                return "memoryCost";
            }
            case 8: {
                return "fragmentJson";
            }
            case 9: {
                return "leafFragment";
            }
            case 10: {
                return "assignment";
            }
            case 11: {
                return "foreman";
            }
            case 12: {
                return "memInitial";
            }
            case 13: {
                return "memMax";
            }
            case 14: {
                return "credentials";
            }
            case 15: {
                return "optionsJson";
            }
            case 16: {
                return "context";
            }
            case 17: {
                return "collector";
            }
        }
        return null;
    }

    public int getFieldNumber(String name) {
        Integer number = __fieldMap.get(name);
        return number == null ? 0 : number;
    }

    static {
        __fieldMap.put("handle", 1);
        __fieldMap.put("networkCost", 4);
        __fieldMap.put("cpuCost", 5);
        __fieldMap.put("diskCost", 6);
        __fieldMap.put("memoryCost", 7);
        __fieldMap.put("fragmentJson", 8);
        __fieldMap.put("leafFragment", 9);
        __fieldMap.put("assignment", 10);
        __fieldMap.put("foreman", 11);
        __fieldMap.put("memInitial", 12);
        __fieldMap.put("memMax", 13);
        __fieldMap.put("credentials", 14);
        __fieldMap.put("optionsJson", 15);
        __fieldMap.put("context", 16);
        __fieldMap.put("collector", 17);
    }
}

