/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.utils.manifest.Parser;

public class ManifestWriter {
    private static final byte[] CONTINUE = new byte[]{13, 10, 32};
    private static final Set<String> NICE_HEADERS = new HashSet<String>(Arrays.asList("Import-Package", "DynamicImport-Package", "Import-Service", "Require-Capability", "Export-Package", "Export-Service", "Provide-Capability", "Require-Bundle", "Bundle-ClassPath", "Embedded-Artifacts"));

    public static void outputManifest(Manifest manifest, OutputStream out, boolean nice) throws IOException {
        ManifestWriter.writeEntry(out, "Manifest-Version", "1.0", nice);
        ManifestWriter.attributes(manifest.getMainAttributes(), out, nice);
        TreeSet<String> keys = new TreeSet<String>();
        for (String o : manifest.getEntries().keySet()) {
            keys.add(o.toString());
        }
        for (String key : keys) {
            ManifestWriter.write(out, 0, "\r\n");
            ManifestWriter.writeEntry(out, "Name", key, nice);
            ManifestWriter.attributes(manifest.getAttributes(key), out, nice);
        }
        out.flush();
    }

    private static void writeEntry(OutputStream out, String name, String value, boolean nice) throws IOException {
        if (nice && NICE_HEADERS.contains(name)) {
            int n = ManifestWriter.write(out, 0, name + ": ");
            String[] parts = Parser.parseDelimitedString((String)value, (String)",");
            if (parts.length > 1) {
                ManifestWriter.write(out, 0, "\r\n ");
                n = 1;
            }
            for (int i = 0; i < parts.length; ++i) {
                if (i < parts.length - 1) {
                    ManifestWriter.write(out, n, parts[i] + ",");
                    ManifestWriter.write(out, 0, "\r\n ");
                } else {
                    ManifestWriter.write(out, n, parts[i]);
                    ManifestWriter.write(out, 0, "\r\n");
                }
                n = 1;
            }
        } else {
            int n = ManifestWriter.write(out, 0, name + ": ");
            ManifestWriter.write(out, n, value);
            ManifestWriter.write(out, 0, "\r\n");
        }
    }

    private static int write(OutputStream out, int i, String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return ManifestWriter.write(out, i, bytes);
    }

    private static int write(OutputStream out, int width, byte[] bytes) throws IOException {
        int w = width;
        for (int i = 0; i < bytes.length; ++i) {
            if (w >= 72) {
                out.write(CONTINUE);
                w = 1;
            }
            out.write(bytes[i]);
            ++w;
        }
        return w;
    }

    private static void attributes(Attributes value, OutputStream out, boolean nice) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        map.remove("Manifest-Version");
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            ManifestWriter.writeEntry(out, (String)entry.getKey(), (String)entry.getValue(), nice);
        }
    }
}

