/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.cm.PersistenceManager;

class CachingPersistenceManagerProxy
implements PersistenceManager {
    private final PersistenceManager pm;
    private final Hashtable cache;
    private boolean fullyLoaded;

    public CachingPersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
        this.cache = new Hashtable();
    }

    public void delete(String pid) throws IOException {
        this.cache.remove(pid);
        this.pm.delete(pid);
    }

    public boolean exists(String pid) {
        return this.cache.containsKey(pid) || this.pm.exists(pid);
    }

    public Enumeration getDictionaries() throws IOException {
        if (!this.fullyLoaded) {
            Enumeration fromPm = this.pm.getDictionaries();
            while (fromPm.hasMoreElements()) {
                Dictionary next = (Dictionary)fromPm.nextElement();
                String pid = (String)next.get("service.pid");
                if (pid == null) continue;
                this.cache.put(pid, next);
            }
            this.fullyLoaded = true;
        }
        return new Enumeration(){
            final Enumeration base;
            {
                this.base = CachingPersistenceManagerProxy.this.cache.elements();
            }

            public boolean hasMoreElements() {
                return this.base.hasMoreElements();
            }

            public Object nextElement() {
                return CachingPersistenceManagerProxy.this.copy((Dictionary)this.base.nextElement());
            }
        };
    }

    public Dictionary load(String pid) throws IOException {
        Dictionary loaded = (Dictionary)this.cache.get(pid);
        if (loaded == null && (loaded = this.pm.load(pid)) != null) {
            this.cache.put(pid, loaded);
        }
        return this.copy(loaded);
    }

    public void store(String pid, Dictionary properties) throws IOException {
        this.pm.store(pid, properties);
        this.cache.put(pid, this.copy(properties));
    }

    Dictionary copy(Dictionary source) {
        Hashtable copy = new Hashtable();
        if (source instanceof Map) {
            copy.putAll((Map)((Object)source));
        } else {
            Enumeration keys = source.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                copy.put(key, source.get(key));
            }
        }
        return copy;
    }
}

