/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;

public class Util {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final String CHECKSUM_SUFFIX = ".checksum";
    private static Logger logger;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public static void performSubstitution(Dictionary properties) {
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String name;
            Object value = properties.get(name = (String)e.nextElement());
            properties.put(name, value instanceof String ? Util.substVars((String)value, name, null, properties) : value);
        }
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Dictionary configProps) throws IllegalArgumentException {
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 || stopDelim < 0) {
            return val;
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Util.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    public static void log(BundleContext context, long debug, String message, Throwable e) {
        Util.getLogger(context).log(debug > 0L, message, e);
    }

    private static Logger getLogger(BundleContext context) {
        try {
            context.getBundle();
            if (logger != null && logger.isValidLogger(context)) {
                return logger;
            }
            logger = new OsgiLogger(context);
        }
        catch (Throwable t) {
            logger = new StdOutLogger();
        }
        return logger;
    }

    public static void jarDir(File directory, File zipName) throws IOException {
        Util.jarDir(directory, new BufferedOutputStream(new FileOutputStream(zipName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDir(File directory, OutputStream os) throws IOException {
        JarOutputStream zos = new JarOutputStream(os);
        String path = "";
        File manFile = new File(directory, "META-INF/MANIFEST.MF");
        if (manFile.exists()) {
            byte[] readBuffer = new byte[8192];
            FileInputStream fis = new FileInputStream(manFile);
            try {
                ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
                zos.putNextEntry(anEntry);
                int bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
        }
        Util.zipDir(directory, zos, path, Collections.singleton("META-INF/MANIFEST.MF"));
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File directory, ZipOutputStream zos, String path, Set exclusions) throws IOException {
        File[] dirList = directory.listFiles();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = dirList[i];
            if (f.isDirectory()) {
                Util.zipDir(f, zos, path + f.getName() + "/", exclusions);
                continue;
            }
            String entry = path + f.getName();
            if (exclusions.contains(entry)) continue;
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry anEntry = new ZipEntry(entry);
                zos.putNextEntry(anEntry);
                bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
                continue;
            }
            finally {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeChecksum(Bundle b, long checksum, BundleContext bc) {
        String key = Util.getBundleKey(b);
        File f = bc.getDataFile(key + CHECKSUM_SUFFIX);
        FilterOutputStream dout = null;
        try {
            dout = new DataOutputStream(new FileOutputStream(f));
            ((DataOutputStream)dout).writeLong(checksum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long loadChecksum(Bundle b, BundleContext bc) {
        String key = Util.getBundleKey(b);
        File f = bc.getDataFile(key + CHECKSUM_SUFFIX);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(f));
            long l = ((DataInputStream)in).readLong();
            return l;
        }
        catch (Exception e) {
            long l = Long.MIN_VALUE;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String getBundleKey(Bundle b) {
        StringBuffer sb = new StringBuffer();
        sb.append(b.getSymbolicName()).append("_");
        String version = (String)b.getHeaders().get("Bundle-Version");
        sb.append(version != null ? version : Version.emptyVersion.toString());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class OsgiLogger
    extends StdOutLogger {
        private BundleContext context;

        OsgiLogger(BundleContext context) {
            this.context = context;
            try {
                this.getClass().getClassLoader().loadClass((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Util.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }

        public boolean isValidLogger(BundleContext context) {
            return context == this.context;
        }

        public void log(boolean debug, String message, Throwable throwable) {
            LogService log = this.getLogService();
            if (log != null) {
                if (throwable != null) {
                    log.log(1, message, throwable);
                    if (debug) {
                        throwable.printStackTrace();
                    }
                } else {
                    log.log(3, message);
                }
            } else {
                super.log(debug, message, throwable);
            }
        }

        private LogService getLogService() {
            ServiceReference ref = this.context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Util.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            if (ref != null) {
                LogService log = (LogService)this.context.getService(ref);
                return log;
            }
            return null;
        }
    }

    static class StdOutLogger
    implements Logger {
        StdOutLogger() {
        }

        public boolean isValidLogger(BundleContext context) {
            return true;
        }

        public void log(boolean debug, String message, Throwable throwable) {
            System.out.println(message + (throwable == null ? "" : ": " + throwable));
            if (debug && throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    static interface Logger {
        public boolean isValidLogger(BundleContext var1);

        public void log(boolean var1, String var2, Throwable var3);
    }
}

