/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.module;

import java.lang.annotation.ElementType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Controller;
import org.apache.felix.ipojo.annotations.Handler;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Modified;
import org.apache.felix.ipojo.annotations.PostRegistration;
import org.apache.felix.ipojo.annotations.PostUnregistration;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceController;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Updated;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ComponentVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ControllerVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.FieldPropertyVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.HandlerDeclarationVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.HandlerVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.InstantiateVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.LifecycleVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.MethodPropertyVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ParameterPropertyVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.PostRegistrationVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ProvidesVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.RequiresVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ServiceControllerVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.UpdatedVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.Action;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.MethodBindVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.ParameterBindVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Names;
import org.apache.felix.ipojo.manipulator.spi.AbsBindingModule;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class DefaultBindingModule
extends AbsBindingModule {
    private DocumentBuilder m_builder;

    public void configure() {
        this.bind(Component.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new ComponentVisitor(context.getWorkbench(), context.getReporter());
            }
        });
        this.bind(Handler.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new HandlerVisitor(context.getWorkbench(), context.getReporter());
            }
        });
        this.bind(Provides.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new ProvidesVisitor(context.getWorkbench());
            }
        });
        this.bind(HandlerDeclaration.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Reporter reporter = context.getReporter();
                return new HandlerDeclarationVisitor(context.getWorkbench(), DefaultBindingModule.this.getFreshDocumentBuilder(reporter), reporter);
            }
        });
        this.bind(Instantiate.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new InstantiateVisitor(context.getWorkbench());
            }
        });
        this.bind(Requires.class).when(Predicates.on(ElementType.FIELD)).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new RequiresVisitor(context.getWorkbench(), ((FieldNode)context.getNode()).name);
            }
        }).when(Predicates.on(ElementType.PARAMETER)).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new ParameterBindVisitor(context.getWorkbench(), Action.BIND, context.getParameterIndex());
            }
        });
        this.bind(Controller.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new ControllerVisitor(context.getWorkbench(), ((FieldNode)context.getNode()).name);
            }
        });
        this.bind(ServiceProperty.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                String name = ((FieldNode)context.getNode()).name;
                ComponentWorkbench workbench = context.getWorkbench();
                if (!workbench.getIds().containsKey("provides")) {
                    context.getReporter().warn("The component does not provide services, skip ServiceProperty for {}", name);
                    return null;
                }
                Element provides = workbench.getIds().get("provides");
                return new FieldPropertyVisitor(name, provides);
            }
        });
        this.bind(ServiceController.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                String name = ((FieldNode)context.getNode()).name;
                ComponentWorkbench workbench = context.getWorkbench();
                if (!workbench.getIds().containsKey("provides")) {
                    context.getReporter().warn("The component does not provide services, skip @ServiceController for {}", name);
                    return null;
                }
                Element provides = workbench.getIds().get("provides");
                return new ServiceControllerVisitor(name, provides);
            }
        });
        this.bind(Property.class).when(Predicates.on(ElementType.FIELD)).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                ComponentWorkbench workbench = context.getWorkbench();
                Element properties = Elements.getPropertiesElement(workbench);
                String name = ((FieldNode)context.getNode()).name;
                return new FieldPropertyVisitor(name, properties);
            }
        }).when(Predicates.on(ElementType.METHOD)).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                ComponentWorkbench workbench = context.getWorkbench();
                Element properties = Elements.getPropertiesElement(workbench);
                String name = ((MethodNode)context.getNode()).name;
                return new MethodPropertyVisitor(properties, name);
            }
        }).when(Predicates.on(ElementType.PARAMETER)).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                ComponentWorkbench workbench = context.getWorkbench();
                Element properties = Elements.getPropertiesElement(workbench);
                MethodNode method = (MethodNode)context.getNode();
                return new ParameterPropertyVisitor(properties, method, context.getParameterIndex());
            }
        });
        this.bind(Validate.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new LifecycleVisitor(context.getWorkbench(), Names.computeEffectiveMethodName(node.name), LifecycleVisitor.Transition.VALIDATE);
            }
        });
        this.bind(Invalidate.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new LifecycleVisitor(context.getWorkbench(), Names.computeEffectiveMethodName(node.name), LifecycleVisitor.Transition.INVALIDATE);
            }
        });
        this.bind(Updated.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new UpdatedVisitor(context.getWorkbench(), Names.computeEffectiveMethodName(node.name));
            }
        });
        this.bind(Bind.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new MethodBindVisitor(context.getWorkbench(), Action.BIND, node.name);
            }
        });
        this.bind(Unbind.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new MethodBindVisitor(context.getWorkbench(), Action.UNBIND, node.name);
            }
        });
        this.bind(Modified.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new MethodBindVisitor(context.getWorkbench(), Action.MODIFIED, node.name);
            }
        });
        this.bind(PostRegistration.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new PostRegistrationVisitor(context.getWorkbench(), node.name);
            }
        });
        this.bind(PostUnregistration.class).to(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                MethodNode node = (MethodNode)context.getNode();
                return new PostRegistrationVisitor(context.getWorkbench(), node.name);
            }
        });
    }

    protected DocumentBuilder getFreshDocumentBuilder(Reporter reporter) {
        if (this.m_builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                this.m_builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                reporter.warn("Cannot get a fresh DocumentBuilder", e);
            }
            return this.m_builder;
        }
        this.m_builder.reset();
        return this.m_builder;
    }
}

