/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Selection;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingRegistry {
    private Map<String, List<Binding>> tree;
    private Reporter reporter;
    private List<Binding> defaultBindings;

    public BindingRegistry(Reporter reporter) {
        this.reporter = reporter;
        this.tree = new HashMap<String, List<Binding>>();
        this.defaultBindings = new ArrayList<Binding>();
    }

    public void addBindings(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            Type type = Type.getType(binding.getAnnotationType());
            List<Binding> potential = this.tree.get(type.getDescriptor());
            if (potential == null) {
                potential = new ArrayList<Binding>();
                this.tree.put(type.getDescriptor(), potential);
            }
            potential.add(binding);
        }
    }

    public Selection selection(ComponentWorkbench workbench) {
        return new Selection(this, workbench, this.reporter);
    }

    public List<Binding> getBindings(String descriptor) {
        return this.tree.get(descriptor);
    }

    public List<Binding> getDefaultBindings() {
        return this.defaultBindings;
    }
}

