/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.Module;
import org.apache.felix.ipojo.manipulator.spi.Predicate;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bindings {
    private static List<Binding> DEFAULT_BINDINGS = new ArrayList<Binding>();

    private static Binding newGenericTypeBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.TYPE), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new TypeGenericVisitor(context.getWorkbench(), element);
            }
        });
        return binding;
    }

    private static Predicate customAnnotationPattern() {
        return Predicates.pattern("(.*\\.ipojo\\..*)|(.*\\.handler\\..*)").matches();
    }

    private static Binding newGenericFieldBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.FIELD), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new FieldGenericVisitor(context.getWorkbench(), element, (FieldNode)context.getNode());
            }
        });
        return binding;
    }

    private static Binding newGenericMethodBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.METHOD), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new MethodGenericVisitor(context.getWorkbench(), element, (MethodNode)context.getNode());
            }
        });
        return binding;
    }

    private static Binding newGenericParameterBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.PARAMETER), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new ParameterGenericVisitor(context.getWorkbench(), element, (MethodNode)context.getNode(), context.getParameterIndex());
            }
        });
        return binding;
    }

    public static BindingRegistry newBindingRegistry(Reporter reporter) {
        BindingRegistry registry = new BindingRegistry(reporter);
        ServiceLoader<Module> loader = ServiceLoader.load(Module.class, Bindings.classloader());
        for (Module module : loader) {
            module.configure();
            registry.addBindings(module);
        }
        registry.getDefaultBindings().addAll(DEFAULT_BINDINGS);
        return registry;
    }

    public static List<Binding> getDefaultBindings() {
        return DEFAULT_BINDINGS;
    }

    private static ClassLoader classloader() {
        return Bindings.class.getClassLoader();
    }

    static {
        DEFAULT_BINDINGS.add(Bindings.newGenericTypeBinding());
        DEFAULT_BINDINGS.add(Bindings.newGenericFieldBinding());
        DEFAULT_BINDINGS.add(Bindings.newGenericMethodBinding());
        DEFAULT_BINDINGS.add(Bindings.newGenericParameterBinding());
        DEFAULT_BINDINGS = Collections.unmodifiableList(DEFAULT_BINDINGS);
    }
}

