/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.apache.felix.webconsole.internal.Logger;
import org.apache.felix.webconsole.internal.core.InstallHelper;
import org.apache.felix.webconsole.internal.core.UpdateHelper;
import org.osgi.framework.Bundle;

public class InstallAction
extends BaseManagementPlugin
implements Action {
    public static final String NAME = "install";
    public static final String LABEL = "Install or Update";
    public static final String FIELD_STARTLEVEL = "bundlestartlevel";
    public static final String FIELD_START = "bundlestart";
    public static final String FIELD_BUNDLEFILE = "bundlefile";
    public static final String FIELD_REFRESH_PACKAGES = "refreshPackages";
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map params = (Map)request.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            return true;
        }
        FileItem startItem = this.getParameter(params, FIELD_START);
        FileItem startLevelItem = this.getParameter(params, FIELD_STARTLEVEL);
        FileItem[] bundleItems = this.getFileItems(params, FIELD_BUNDLEFILE);
        FileItem refreshPackagesItem = this.getParameter(params, FIELD_REFRESH_PACKAGES);
        if (bundleItems.length == 0) {
            return true;
        }
        int startLevel = -1;
        String bundleLocation = "inputstream:";
        if (startLevelItem != null) {
            try {
                startLevel = Integer.parseInt(startLevelItem.getString());
            }
            catch (NumberFormatException nfe) {
                this.getLog().log(3, "Cannot parse start level parameter " + startLevelItem + " to a number, not setting start level");
            }
        }
        for (int i = 0; i < bundleItems.length; ++i) {
            File tmpFile;
            FileItem bundleItem;
            block8: {
                bundleItem = bundleItems[i];
                tmpFile = null;
                try {
                    tmpFile = File.createTempFile(NAME, ".tmp");
                    bundleItem.write(tmpFile);
                }
                catch (Exception e) {
                    this.getLog().log(1, "Problem accessing uploaded bundle file: " + bundleItem.getName(), e);
                    if (tmpFile == null) break block8;
                    tmpFile.delete();
                    tmpFile = null;
                }
            }
            if (tmpFile == null) continue;
            boolean start = startItem != null;
            boolean refreshPackages = refreshPackagesItem != null;
            bundleLocation = "inputstream:" + bundleItem.getName();
            this.installBundle(bundleLocation, tmpFile, startLevel, start, refreshPackages);
        }
        return true;
    }

    private FileItem getParameter(Map params, String name) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].isFormField()) continue;
                return items[i];
            }
        }
        return null;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    private void installBundle(String location, File bundleFile, int startLevel, boolean start, boolean refreshPackages) throws IOException {
        if (bundleFile != null) {
            String symbolicName = this.getSymbolicName(bundleFile);
            if (symbolicName == null) {
                bundleFile.delete();
                throw new IOException("Bundle-SymbolicName header missing, cannot install bundle");
            }
            Bundle updateBundle = null;
            if ("system.bundle".equals(symbolicName)) {
                updateBundle = this.getBundleContext().getBundle(0L);
            } else {
                Bundle[] bundles = this.getBundleContext().getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if ((bundles[i].getLocation() == null || !bundles[i].getLocation().equals(location)) && (bundles[i].getSymbolicName() == null || !bundles[i].getSymbolicName().equals(symbolicName))) continue;
                    updateBundle = bundles[i];
                    break;
                }
            }
            if (updateBundle != null) {
                this.updateBackground(updateBundle, bundleFile, refreshPackages);
            } else {
                this.installBackground(bundleFile, location, startLevel, start, refreshPackages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSymbolicName(File bundleFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(bundleFile);
            Manifest m = jar.getManifest();
            if (m != null) {
                String string = m.getMainAttributes().getValue("Bundle-SymbolicName");
                return string;
            }
        }
        catch (IOException ioe) {
            this.getLog().log(2, "Cannot extract symbolic name of bundle file " + bundleFile, ioe);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void installBackground(File bundleFile, String location, int startlevel, boolean doStart, boolean refreshPackages) {
        InstallHelper t = new InstallHelper(this.getBundleContext(), bundleFile, location, startlevel, doStart, refreshPackages){

            protected Logger getLog() {
                return InstallAction.this.getLog();
            }

            protected Object getService(String serviceName) {
                if (serviceName.equals((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = InstallAction.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName())) {
                    return InstallAction.this.getPackageAdmin();
                }
                if (serviceName.equals((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = InstallAction.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName())) {
                    return InstallAction.this.getStartLevel();
                }
                return null;
            }
        };
        t.start();
    }

    private void updateBackground(Bundle bundle, File bundleFile, boolean refreshPackages) {
        UpdateHelper t = new UpdateHelper(bundle, bundleFile, refreshPackages){

            protected Logger getLog() {
                return InstallAction.this.getLog();
            }

            protected Object getService(String serviceName) {
                if (serviceName.equals((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = InstallAction.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName())) {
                    return InstallAction.this.getPackageAdmin();
                }
                return null;
            }
        };
        t.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

