/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.deppack;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public class DepPackServlet
extends BaseWebConsolePlugin {
    public static final String LABEL = "deppack";
    public static final String TITLE = "Deployment Packages";
    private static final String ACTION_DEPLOY = "deploydp";
    private static final String ACTION_UNINSTALL = "uninstalldp";
    private static final String PARAMETER_PCK_FILE = "pckfile";
    static /* synthetic */ Class class$org$osgi$service$deploymentadmin$DeploymentAdmin;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void activate(ComponentContext context) {
        this.activate(context.getBundleContext());
    }

    protected void deactivate(ComponentContext context) {
        this.deactivate();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = DepPackServlet.getParameter(req, "action");
        if (ACTION_DEPLOY.equals(action)) {
            Map params = (Map)req.getAttribute("org.apache.felix.webconsole.fileupload");
            if (params != null) {
                FileItem pck = this.getFileItem(params, PARAMETER_PCK_FILE, false);
                DeploymentAdmin admin = (DeploymentAdmin)this.getService((class$org$osgi$service$deploymentadmin$DeploymentAdmin == null ? (class$org$osgi$service$deploymentadmin$DeploymentAdmin = DepPackServlet.class$("org.osgi.service.deploymentadmin.DeploymentAdmin")) : class$org$osgi$service$deploymentadmin$DeploymentAdmin).getName());
                if (admin != null) {
                    try {
                        admin.installDeploymentPackage(pck.getInputStream());
                        String uri = req.getRequestURI();
                        resp.sendRedirect(uri);
                        return;
                    }
                    catch (DeploymentException e) {
                        throw new ServletException("Unable to deploy package.", (Throwable)e);
                    }
                }
            }
            throw new ServletException("Upload file or deployment admin missing.");
        }
        if (ACTION_UNINSTALL.equals(action)) {
            DeploymentAdmin admin;
            String pckId = req.getPathInfo().substring(req.getPathInfo().lastIndexOf(47) + 1);
            if (pckId != null && pckId.length() > 0 && (admin = (DeploymentAdmin)this.getService((class$org$osgi$service$deploymentadmin$DeploymentAdmin == null ? (class$org$osgi$service$deploymentadmin$DeploymentAdmin = DepPackServlet.class$("org.osgi.service.deploymentadmin.DeploymentAdmin")) : class$org$osgi$service$deploymentadmin$DeploymentAdmin).getName())) != null) {
                try {
                    DeploymentPackage pck = admin.getDeploymentPackage(pckId);
                    if (pck != null) {
                        pck.uninstall();
                    }
                }
                catch (DeploymentException e) {
                    throw new ServletException("Unable to undeploy package.", (Throwable)e);
                }
            }
            PrintWriter pw = resp.getWriter();
            pw.println("{ \"reload\":true }");
            return;
        }
        throw new ServletException("Unknown action: " + action);
    }

    private FileItem getFileItem(Map params, String name, boolean isFormField) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() != isFormField) continue;
                return items[i];
            }
        }
        return null;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        pw.println("<script src='" + appRoot + "/res/ui/packages.js' language='JavaScript'></script>");
        pw.println("<h1>Deployment Admin</h1>");
        DeploymentAdmin admin = (DeploymentAdmin)this.getService((class$org$osgi$service$deploymentadmin$DeploymentAdmin == null ? (class$org$osgi$service$deploymentadmin$DeploymentAdmin = DepPackServlet.class$("org.osgi.service.deploymentadmin.DeploymentAdmin")) : class$org$osgi$service$deploymentadmin$DeploymentAdmin).getName());
        if (admin == null) {
            pw.println("<p><em>Deployment Admin is not installed.</em></p>");
            return;
        }
        DeploymentPackage[] packages = admin.listDeploymentPackages();
        Util.startScript(pw);
        pw.println("var packageListData = ");
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("data");
            jw.array();
            for (int i = 0; i < packages.length; ++i) {
                this.packageInfoJson(jw, packages[i]);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
        pw.println(";");
        pw.println("renderPackage( packageListData );");
        Util.endScript(pw);
    }

    private void packageInfoJson(JSONWriter jw, DeploymentPackage pack) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)pack.getName());
        jw.key("name");
        jw.value((Object)pack.getName());
        jw.key("state");
        jw.value((Object)pack.getVersion());
        jw.key("actions");
        jw.array();
        jw.object();
        jw.key("enabled");
        jw.value(true);
        jw.key("name");
        jw.value((Object)"Uninstall");
        jw.key("link");
        jw.value((Object)ACTION_UNINSTALL);
        jw.endObject();
        jw.endArray();
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Package Name", pack.getName());
        this.keyVal(jw, "Version", pack.getVersion());
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < pack.getBundleInfos().length; ++i) {
            buffer.append(pack.getBundleInfos()[i].getSymbolicName());
            buffer.append(" - ");
            buffer.append(pack.getBundleInfos()[i].getVersion());
            buffer.append("<br/>");
        }
        this.keyVal(jw, "Bundles", buffer.toString());
        jw.endArray();
        jw.endObject();
    }

    private void keyVal(JSONWriter jw, String key, Object value) throws JSONException {
        if (key != null && value != null) {
            jw.object();
            jw.key("key");
            jw.value((Object)key);
            jw.key("value");
            jw.value(value);
            jw.endObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

