/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.obr.AbstractObrPlugin;
import org.apache.felix.webconsole.internal.obr.DeployerThread;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

public class InstallFromRepoAction
extends AbstractObrPlugin
implements Action {
    public static final String NAME = "installFromOBR";

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return NAME;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) {
        String[] bundles = request.getParameterValues("bundle");
        if (bundles == null || bundles.length == 0) {
            this.getLog().log(3, "No resources to deploy");
            return true;
        }
        RepositoryAdmin repoAdmin = this.getRepositoryAdmin();
        if (repoAdmin != null) {
            Resolver resolver = repoAdmin.resolver();
            for (int i = 0; i < bundles.length; ++i) {
                String filter;
                Resource[] resources;
                String version;
                String bundle = bundles[i];
                if (bundle == null || bundle.equals("-")) continue;
                int comma = bundle.indexOf(44);
                String name = comma > 0 ? bundle.substring(0, comma) : bundle;
                String string = version = comma < bundle.length() - 1 ? bundle.substring(comma + 1) : null;
                if (name.length() <= 0) continue;
                if (version == null) {
                    version = "*";
                }
                if ((resources = repoAdmin.discoverResources(filter = "(&(symbolicname=" + name + ")(version=" + version + "))")) == null || resources.length <= 0) continue;
                resolver.add(resources[0]);
            }
            boolean start = request.getParameter("deploystart") != null;
            DeployerThread dt = new DeployerThread(resolver, this.getLog(), start);
            dt.start();
        }
        return true;
    }
}

