/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.sqlserver.database.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialectConverter;
import org.apache.flink.connector.jdbc.sqlserver.database.dialect.SqlServerDialectConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class SqlServerDialect
extends AbstractDialect {
    public String dialectName() {
        return "SqlServer";
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)0, (int)7));
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)0, (int)38));
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(f -> !Arrays.asList(uniqueKeyFields).contains(f)).collect(Collectors.toList());
        String fieldsProjection = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesBinding = Arrays.stream(fieldNames).map(f -> ":" + f + " " + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(f -> "[TARGET]." + this.quoteIdentifier((String)f) + "=[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(f -> "[TARGET]." + this.quoteIdentifier((String)f) + "=[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(f -> "[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        return Optional.of(String.format("MERGE INTO %s AS [TARGET] USING (%s) AS [SOURCE] ON (%s) WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s);", this.quoteIdentifier(tableName), usingClause, onConditions, updateSetClause, fieldsProjection, insertValues));
    }

    public JdbcDialectConverter getRowConverter(RowType rowType) {
        return new SqlServerDialectConverter(rowType);
    }

    public String getLimitClause(long limit) {
        throw new IllegalArgumentException("SqlServerDialect does not support limit clause");
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE});
    }
}

