/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.table.data.RowData;

public final class TableBufferedStatementExecutor
implements JdbcBatchStatementExecutor<RowData> {
    private final JdbcBatchStatementExecutor<RowData> statementExecutor;
    private final Function<RowData, RowData> valueTransform;
    private final List<RowData> buffer = new ArrayList<RowData>();

    public TableBufferedStatementExecutor(JdbcBatchStatementExecutor<RowData> statementExecutor, Function<RowData, RowData> valueTransform) {
        this.statementExecutor = statementExecutor;
        this.valueTransform = valueTransform;
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.statementExecutor.prepareStatements(connection);
    }

    @Override
    public void addToBatch(RowData record) throws SQLException {
        RowData value = this.valueTransform.apply(record);
        this.buffer.add(value);
    }

    @Override
    public void executeBatch() throws SQLException {
        for (RowData value : this.buffer) {
            this.statementExecutor.addToBatch(value);
        }
        this.statementExecutor.executeBatch();
        this.buffer.clear();
    }

    @Override
    public void closeStatements() throws SQLException {
        this.statementExecutor.closeStatements();
    }
}

