/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.trino.dialect;

import java.math.BigDecimal;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.converter.AbstractJdbcRowConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class TrinoRowConverter
extends AbstractJdbcRowConverter {
    private static final long serialVersionUID = 1L;

    public TrinoRowConverter(RowType rowType) {
        super(rowType);
    }

    @Override
    public AbstractJdbcRowConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BIGINT: {
                return val -> val instanceof Number ? Long.valueOf(((Number)val).longValue()) : val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> val instanceof Number ? DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(((Number)val).doubleValue()), (int)precision, (int)scale) : val;
            }
        }
        return super.createInternalConverter(type);
    }

    @Override
    public String converterName() {
        return "Trino";
    }
}

