/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class JdbcOutputSerializer<T>
implements Serializable {
    private final TypeSerializer<T> typeSerializer;
    private boolean objectReuse;

    private JdbcOutputSerializer(TypeSerializer<T> typeSerializer, boolean objectReuse) {
        this.typeSerializer = typeSerializer;
        this.objectReuse = objectReuse;
    }

    public static <S> JdbcOutputSerializer<S> of(TypeSerializer<S> typeSerializer) {
        return JdbcOutputSerializer.of(typeSerializer, false);
    }

    public static <S> JdbcOutputSerializer<S> of(TypeSerializer<S> typeSerializer, boolean objectReuse) {
        return new JdbcOutputSerializer<S>(typeSerializer, objectReuse);
    }

    public JdbcOutputSerializer<T> withObjectReuseEnabled(boolean enabled) {
        this.objectReuse = enabled;
        return this;
    }

    public T serialize(T record) {
        return (T)(this.objectReuse ? this.typeSerializer.copy(record) : record);
    }
}

