/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source.reader;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.base.source.reader.RecordsBySplits;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.source.JdbcSourceOptions;
import org.apache.flink.connector.jdbc.source.reader.RecordAndOffset;
import org.apache.flink.connector.jdbc.source.reader.extractor.ResultExtractor;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplit;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceSplitReader<T>
implements SplitReader<RecordAndOffset<T>, JdbcSourceSplit>,
ResultTypeQueryable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSourceSplitReader.class);
    private final Configuration config;
    @Nullable
    private JdbcSourceSplit currentSplit;
    private final Queue<JdbcSourceSplit> splits;
    private final TypeInformation<T> typeInformation;
    private final JdbcConnectionProvider connectionProvider;
    private transient Connection connection;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private final ResultExtractor<T> resultExtractor;
    protected boolean hasNextRecordCurrentSplit;
    private final DeliveryGuarantee deliveryGuarantee;
    private final int splitReaderFetchBatchSize;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetFetchSize;
    private final Boolean autoCommit;
    private int currentSplitOffset;
    private final SourceReaderContext context;

    public JdbcSourceSplitReader(SourceReaderContext context, Configuration config, TypeInformation<T> typeInformation, JdbcConnectionProvider connectionProvider, DeliveryGuarantee deliveryGuarantee, ResultExtractor<T> resultExtractor) {
        this.context = (SourceReaderContext)Preconditions.checkNotNull((Object)context);
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
        this.typeInformation = (TypeInformation)Preconditions.checkNotNull(typeInformation);
        this.connectionProvider = (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider);
        this.resultSetType = config.getInteger(JdbcSourceOptions.RESULTSET_TYPE);
        this.resultSetConcurrency = config.getInteger(JdbcSourceOptions.RESULTSET_CONCURRENCY);
        this.resultSetFetchSize = config.getInteger(JdbcSourceOptions.RESULTSET_FETCH_SIZE);
        this.autoCommit = config.getBoolean(JdbcSourceOptions.AUTO_COMMIT);
        this.deliveryGuarantee = (DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee);
        this.splits = new ArrayDeque<JdbcSourceSplit>();
        this.hasNextRecordCurrentSplit = false;
        this.currentSplit = null;
        int splitReaderFetchBatchSize = config.getInteger(JdbcSourceOptions.READER_FETCH_BATCH_SIZE);
        Preconditions.checkArgument((splitReaderFetchBatchSize > 0 && splitReaderFetchBatchSize < Integer.MAX_VALUE ? 1 : 0) != 0);
        this.splitReaderFetchBatchSize = splitReaderFetchBatchSize;
        this.resultExtractor = (ResultExtractor)Preconditions.checkNotNull(resultExtractor);
        this.currentSplitOffset = 0;
    }

    public RecordsWithSplitIds<RecordAndOffset<T>> fetch() throws IOException {
        this.checkSplitOrStartNext();
        if (!this.hasNextRecordCurrentSplit) {
            return this.finishSplit();
        }
        RecordsBySplits.Builder recordAndOffsetBuilder = new RecordsBySplits.Builder();
        Preconditions.checkState((this.currentSplit != null ? 1 : 0) != 0, (Object)"currentSplit");
        for (int batch = this.splitReaderFetchBatchSize; batch > 0 && this.hasNextRecordCurrentSplit; --batch) {
            try {
                T record = this.resultExtractor.extract(this.resultSet);
                recordAndOffsetBuilder.add((SourceSplit)this.currentSplit, new RecordAndOffset<T>(record, ++this.currentSplitOffset, 0L));
                this.hasNextRecordCurrentSplit = this.resultSet.next();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.hasNextRecordCurrentSplit) {
            this.currentSplitOffset = 0;
            recordAndOffsetBuilder.addFinishedSplit(this.currentSplit.splitId());
            this.closeResultSetAndStatement();
        }
        return recordAndOffsetBuilder.build();
    }

    private RecordsWithSplitIds<RecordAndOffset<T>> finishSplit() {
        this.closeResultSetAndStatement();
        RecordsBySplits.Builder builder = new RecordsBySplits.Builder();
        Preconditions.checkState((this.currentSplit != null ? 1 : 0) != 0, (Object)"currentSplit");
        builder.addFinishedSplit(this.currentSplit.splitId());
        this.currentSplit = null;
        return builder.build();
    }

    private void closeResultSetAndStatement() {
        try {
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            this.resultSet = null;
            this.statement = null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleSplitsChanges(SplitsChange<JdbcSourceSplit> splitsChanges) {
        if (!(splitsChanges instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChanges.getClass()));
        }
        LOG.debug("Handling split change {}", splitsChanges);
        this.splits.addAll(splitsChanges.splits());
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        this.closeResultSetAndStatement();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
        this.currentSplit = null;
    }

    public TypeInformation<T> getProducedType() {
        return this.typeInformation;
    }

    private void checkSplitOrStartNext() {
        try {
            if (this.hasNextRecordCurrentSplit && this.resultSet != null) {
                return;
            }
            JdbcSourceSplit nextSplit = this.splits.poll();
            if (nextSplit == null) {
                throw new IOException("Cannot fetch from another split - no split remaining");
            }
            this.currentSplit = nextSplit;
            this.openResultSetForSplit(this.currentSplit);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void discardSplit(JdbcSourceSplit split) throws SQLException {
        if (split.getOffset() != 0) {
            this.hasNextRecordCurrentSplit = false;
            this.currentSplitOffset = 0;
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            this.resultSet = null;
            this.statement = null;
            this.currentSplit = null;
        }
    }

    private void getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        this.connection = this.connectionProvider.getOrEstablishConnection();
        if (this.autoCommit == null) {
            return;
        }
        if (this.autoCommit.booleanValue() != this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(this.autoCommit);
        }
    }

    private void openResultSetForSplit(JdbcSourceSplit split) throws SQLException, ClassNotFoundException {
        this.getOrEstablishConnection();
        this.statement = this.connection.prepareStatement(split.getSqlTemplate(), this.resultSetType, this.resultSetConcurrency);
        if (split.getParameters() != null) {
            Object[] objs = split.getParameters();
            for (int i = 0; i < objs.length; ++i) {
                this.statement.setObject(i + 1, objs[i]);
            }
        }
        this.statement.setFetchSize(this.resultSetFetchSize);
        this.resultSet = this.statement.executeQuery();
        this.hasNextRecordCurrentSplit = this.resultSet.next();
    }

    @VisibleForTesting
    public List<JdbcSourceSplit> getSplits() {
        return Collections.unmodifiableList(Arrays.asList(this.splits.toArray(new JdbcSourceSplit[0])));
    }

    @VisibleForTesting
    public Connection getConnection() {
        return this.connection;
    }

    @VisibleForTesting
    public PreparedStatement getStatement() {
        return this.statement;
    }

    @VisibleForTesting
    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

