/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog;

import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.databases.cratedb.catalog.CrateDBCatalog;
import org.apache.flink.connector.jdbc.databases.cratedb.dialect.CrateDBDialect;
import org.apache.flink.connector.jdbc.databases.mysql.catalog.MySqlCatalog;
import org.apache.flink.connector.jdbc.databases.mysql.dialect.MySqlDialect;
import org.apache.flink.connector.jdbc.databases.postgres.catalog.PostgresCatalog;
import org.apache.flink.connector.jdbc.databases.postgres.dialect.PostgresDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectLoader;
import org.apache.flink.util.Preconditions;

public class JdbcCatalogUtils {
    public static void validateJdbcUrl(String url) {
        String[] parts = url.trim().split("\\/+");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
    }

    public static AbstractJdbcCatalog createCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl, String compatibleMode) {
        JdbcDialect dialect = JdbcDialectLoader.load(baseUrl, compatibleMode, userClassLoader);
        if (dialect instanceof PostgresDialect) {
            return new PostgresCatalog(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        if (dialect instanceof CrateDBDialect) {
            return new CrateDBCatalog(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        if (dialect instanceof MySqlDialect) {
            return new MySqlCatalog(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        throw new UnsupportedOperationException(String.format("Catalog for '%s' is not supported yet.", dialect));
    }
}

