/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.oceanbase.dialect;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.databases.mysql.dialect.MySqlDialect;
import org.apache.flink.connector.jdbc.databases.oceanbase.dialect.OceanBaseRowConverter;
import org.apache.flink.connector.jdbc.databases.oracle.dialect.OracleDialect;
import org.apache.flink.connector.jdbc.dialect.AbstractDialect;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class OceanBaseDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private final AbstractDialect dialect;

    public OceanBaseDialect(@Nonnull String compatibleMode) {
        switch (compatibleMode.toLowerCase()) {
            case "mysql": {
                this.dialect = new MySqlDialect();
                break;
            }
            case "oracle": {
                this.dialect = new OracleDialect();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported compatible mode: " + compatibleMode);
            }
        }
    }

    @Override
    public String dialectName() {
        return "OceanBase";
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("com.oceanbase.jdbc.Driver");
    }

    @Override
    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE});
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new OceanBaseRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return this.dialect.getLimitClause(limit);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return this.dialect.quoteIdentifier(identifier);
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        return this.dialect.getUpsertStatement(tableName, fieldNames, conditionFields);
    }

    @Override
    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return this.dialect.timestampPrecisionRange();
    }

    @Override
    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return this.dialect.decimalPrecisionRange();
    }

    @Override
    public String appendDefaultUrlProperties(String url) {
        return this.dialect.appendDefaultUrlProperties(url);
    }
}

