/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public class RowJdbcOutputFormat<In>
extends JdbcOutputFormat<In, Row, JdbcBatchStatementExecutor<Row>> {
    public RowJdbcOutputFormat(@Nonnull JdbcConnectionProvider connectionProvider, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull JdbcOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> statementExecutorFactory) {
        super(connectionProvider, executionOptions, statementExecutorFactory);
    }

    static JdbcBatchStatementExecutor<Row> createSimpleRowExecutor(String sql, int[] fieldTypes) {
        return JdbcBatchStatementExecutor.simple(sql, RowJdbcOutputFormat.createRowJdbcStatementBuilder(fieldTypes));
    }

    static JdbcStatementBuilder<Row> createRowJdbcStatementBuilder(int[] types) {
        return (st, record) -> JdbcUtils.setRecordToStatement(st, types, record);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InternalJdbcConnectionOptions options;
        private JdbcDmlOptions.JdbcDmlOptionsBuilder dmlOptionsBuilder = JdbcDmlOptions.builder();
        private JdbcExecutionOptions.Builder executionOptionsBuilder = JdbcExecutionOptions.builder();

        public Builder setOptions(InternalJdbcConnectionOptions options) {
            this.options = options;
            this.dmlOptionsBuilder.withTableName(options.getTableName()).withDialect(options.getDialect());
            return this;
        }

        public Builder setFieldNames(String[] fieldNames) {
            this.dmlOptionsBuilder.withFieldNames(fieldNames);
            return this;
        }

        public Builder setKeyFields(String[] keyFields) {
            this.dmlOptionsBuilder.withKeyFields(keyFields);
            return this;
        }

        public Builder setFieldTypes(int[] fieldTypes) {
            this.dmlOptionsBuilder.withFieldTypes(fieldTypes);
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.executionOptionsBuilder.withBatchSize(flushMaxSize);
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.executionOptionsBuilder.withBatchIntervalMs(flushIntervalMills);
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.executionOptionsBuilder.withMaxRetries(maxRetryTimes);
            return this;
        }

        public JdbcOutputFormat<Row, Row, JdbcBatchStatementExecutor<Row>> build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            JdbcDmlOptions dml = this.dmlOptionsBuilder.build();
            String sql = FieldNamedPreparedStatementImpl.parseNamedStatement(this.options.getDialect().getInsertIntoStatement(dml.getTableName(), dml.getFieldNames()), new HashMap<String, List<Integer>>());
            return new RowJdbcOutputFormat<Row>((JdbcConnectionProvider)new SimpleJdbcConnectionProvider(this.options), this.executionOptionsBuilder.build(), (JdbcOutputFormat.StatementExecutorFactory & Serializable)() -> RowJdbcOutputFormat.createSimpleRowExecutor(sql, dml.getFieldTypes()));
        }
    }
}

